/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.provider;

import com.sighs.generalfeedback.api.FeedbackProvider;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.init.Form;
import com.sighs.generalfeedback.utils.FeedbackUtils;
import com.sighs.generalfeedback.utils.HttpUtil;
import java.util.HashMap;

public class VikaFeedbackProvider
implements FeedbackProvider {
    @Override
    public boolean supports(Entry entry) {
        return entry.url.contains("api.vika.cn");
    }

    @Override
    public void sendFeedback(Entry entry, Form form) {
        FeedbackUtils.showSendingToast();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + entry.token);
        headers.put("Content-Type", "application/json");
        String jsonBody = "{\"records\": [{\"fields\": {\"\u610f\u89c1\u53cd\u9988\": \"" + FeedbackUtils.escapeJson(form.feedback) + "\",\"\u4f53\u9a8c\u8bc4\u5206\": " + form.mark + ",\"\u843d\u6b3e\": \"" + FeedbackUtils.escapeJson(form.contact) + "\"}}],\"fieldKey\": \"name\"}";
        HttpUtil.fetch(entry.url, "POST", headers, jsonBody, null, 5000, response -> FeedbackUtils.handleSuccess(response, entry.id), FeedbackUtils::handleFailure);
    }
}

