/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.generalfeedback.utils;

import com.sighs.generalfeedback.Generalfeedback;
import com.sighs.generalfeedback.api.FeedbackProvider;
import com.sighs.generalfeedback.client.FeedbackScreen;
import com.sighs.generalfeedback.client.ItemIconToast;
import com.sighs.generalfeedback.init.Entry;
import com.sighs.generalfeedback.init.Form;
import com.sighs.generalfeedback.loader.EntryCache;
import com.sighs.generalfeedback.provider.GitHubFeedbackProvider;
import com.sighs.generalfeedback.provider.GiteeFeedbackProvider;
import com.sighs.generalfeedback.provider.VikaFeedbackProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FeedbackUtils {
    public static HashMap<String, String> cache = new HashMap();
    private static final List<FeedbackProvider> providers = new ArrayList<FeedbackProvider>();

    public static void post(Entry entry, Form form) {
        for (FeedbackProvider provider : providers) {
            if (!provider.supports(entry)) continue;
            provider.sendFeedback(entry, form);
            return;
        }
        FeedbackUtils.handleFailure("Unsupported feedback provider for URL: " + entry.url);
    }

    public static void showSendingToast() {
        ItemIconToast.show((Component)Component.m_237115_((String)"toast.generalfeedback.sending.title"), (Component)Component.m_237115_((String)"toast.generalfeedback.sending.desc"), new ItemStack((ItemLike)Items.f_42403_));
    }

    public static void handleSuccess(String response, String entryId) {
        FeedbackUtils.sendSuccess(response);
        cache.remove(entryId);
    }

    public static void handleFailure(String error) {
        FeedbackUtils.sendFail(error);
    }

    public static String escapeJson(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static String toJsonArray(List<String> items) {
        if (items == null || items.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < items.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(FeedbackUtils.escapeJson(items.get(i))).append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String generateIssueTitle(Form form) {
        return (String)(form.mark != 0 ? "(" + form.mark + "\u2605) " : "") + Minecraft.m_91087_().f_91074_.m_5446_().getString() + ": " + form.feedback.substring(0, Math.min(form.feedback.length(), 30)) + (form.feedback.length() > 30 ? "......" : "");
    }

    public static String generateIssueBody(Form form) {
        return form.feedback + "\n\nFrom:\n" + form.contact;
    }

    private static void sendSuccess(String response) {
        Minecraft.m_91087_().execute(() -> {
            Generalfeedback.LOGGER.warn("Response:{}", (Object)response);
            Minecraft.m_91087_().m_91300_().m_94919_();
            ItemIconToast.show((Component)Component.m_237115_((String)"toast.generalfeedback.send_success.title"), (Component)Component.m_237115_((String)"toast.generalfeedback.send_success.desc"), new ItemStack((ItemLike)Items.f_42525_));
        });
    }

    private static void sendFail(String error) {
        Minecraft.m_91087_().execute(() -> {
            Generalfeedback.LOGGER.warn(error);
            ItemIconToast.show((Component)Component.m_237115_((String)"toast.generalfeedback.send_fail.title"), (Component)Component.m_237115_((String)"toast.generalfeedback.send_fail.desc"), new ItemStack((ItemLike)Items.f_42451_));
        });
    }

    public static void openFeedbackScreenOf(String id) {
        if (EntryCache.UnitMapCache.containsKey(id)) {
            Minecraft.m_91087_().m_91152_((Screen)new FeedbackScreen(EntryCache.UnitMapCache.get(id)));
        }
    }

    static {
        providers.add(new VikaFeedbackProvider());
        providers.add(new GitHubFeedbackProvider());
        providers.add(new GiteeFeedbackProvider());
    }
}

