/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.blockentities;

import com.fireblaze.realistic_furnace.blockentities.ModBlockEntities;
import com.fireblaze.realistic_furnace.blocks.FurnaceControllerBlock;
import com.fireblaze.realistic_furnace.client.renderer.FurnaceGhostRenderer;
import com.fireblaze.realistic_furnace.fuel.FurnaceFuelRegistry;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblock;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRenderer;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.fireblaze.realistic_furnace.recipe.Realistic_Furnace_Recipe;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class FurnaceControllerBlockEntity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot <= 7) {
                return 1;
            }
            if (slot == 8) {
                return 8;
            }
            return super.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 8) {
                return FurnaceFuelRegistry.isFuel(stack);
            }
            return true;
        }
    };
    private float heat = 0.0f;
    private int maxHeat = 1800;
    private final float[] progress = new float[8];
    private final int maxProgress = 1000;
    private int burnTime = 0;
    private int burnTimeTotal = 0;
    private ItemStack activeFuel = ItemStack.f_41583_;
    private static final float HEAT_DECREASE_BASE = 0.15f;
    private static final int MAX_HEAT = 1800;
    private static final int THREATENING_HEAT = 1650;
    private static final int MIN_HEAT = 0;
    private static final float DOOR_OPEN_MULTIPLIER = 20.0f;
    private static final float DOOR_CLOSED_MULTIPLIER = 12.0f;
    private static final int SCATTER_CHANCE = 75;
    private int tickCounter = 0;
    public static final int tickInterval = 5;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private boolean showGhost = true;
    private final ContainerData heatData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> (int)FurnaceControllerBlockEntity.this.heat;
                case 1 -> 1800;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceControllerBlockEntity.this.heat = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private final ContainerData progressData = new ContainerData(){

        public int m_6413_(int index) {
            int slot = index / 2;
            boolean isStalled = FurnaceControllerBlockEntity.this.stalled[slot];
            if (index % 2 == 0) {
                return (int)(FurnaceControllerBlockEntity.this.progress[slot] * 100.0f);
            }
            return isStalled ? 1 : 0;
        }

        public void m_8050_(int index, int value) {
            int slot = index / 2;
            if (index % 2 == 0) {
                FurnaceControllerBlockEntity.this.progress[slot] = (float)value / 100.0f;
            } else {
                FurnaceControllerBlockEntity.this.stalled[slot] = value != 0;
            }
        }

        public int m_6499_() {
            return FurnaceControllerBlockEntity.this.progress.length * 2;
        }
    };
    private final ContainerData burnTimeData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> FurnaceControllerBlockEntity.this.burnTime;
                case 1 -> FurnaceControllerBlockEntity.this.burnTimeTotal;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceControllerBlockEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    FurnaceControllerBlockEntity.this.burnTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int ticksRunning = 0;
    private final ItemStack[] lastItems = new ItemStack[8];
    private final boolean[] stalled = new boolean[8];
    private GhostMode ghostMode = GhostMode.BLOCK_BY_BLOCK;

    public FurnaceControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FURNACE_CONTROLLER.get(), pos, state);
    }

    public boolean shouldRenderGhost() {
        return this.showGhost;
    }

    public void updateGhostState(Level level) {
        if (level == null || level.f_46443_) {
            return;
        }
        List<OffsetBlock> missing = FurnaceMultiblockRenderer.getMissingBlocks(level, this.f_58858_);
        this.showGhost = !missing.isEmpty();
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            FurnaceGhostRenderer.register(this);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        FurnaceGhostRenderer.unregister(this);
    }

    public ContainerData getProgressData() {
        return this.progressData;
    }

    public ContainerData getHeatData() {
        return this.heatData;
    }

    public ContainerData getBurnTimeData() {
        return this.burnTimeData;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public float getHeat() {
        return this.heat;
    }

    public int getMaxHeat() {
        return 1800;
    }

    public static int getThreateningHeat() {
        return 1650;
    }

    public float[] getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return 1000;
    }

    public boolean isStalled(int slot) {
        if (slot < 0 || slot >= this.stalled.length) {
            return false;
        }
        return this.stalled[slot];
    }

    public void setStalled(int slot, boolean value) {
        if (slot < 0 || slot >= this.stalled.length) {
            return;
        }
        this.stalled[slot] = value;
    }

    public void setHeat(float heat) {
        this.heat = Mth.m_14036_((float)heat, (float)0.0f, (float)1800.0f);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!FurnaceMultiblock.validateStructure(this.f_58857_, this.f_58858_)) {
            this.heat = 0.0f;
            this.m_6596_();
            this.turnFurnaceOff();
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 5 != 0) {
            return;
        }
        ItemStack fuel = this.itemHandler.getStackInSlot(8);
        boolean isBurning = false;
        if (this.burnTime <= 0 && !fuel.m_41619_() && FurnaceFuelRegistry.isFuel(fuel)) {
            this.burnTimeTotal = this.burnTime = FurnaceFuelRegistry.getBurnTime(fuel);
            this.activeFuel = fuel.m_41777_();
            fuel.m_41774_(1);
            this.itemHandler.setStackInSlot(8, fuel);
        }
        if (this.burnTime > 0) {
            this.burnTime -= 5;
            isBurning = true;
        }
        if (!isBurning && this.heat <= 50.0f) {
            this.heat = 0.0f;
            this.toggleLid(false);
            this.setCampfireLit(false);
            return;
        }
        this.heat = this.calculateNewHeat(this.heat, isBurning);
        if (this.heat >= 1650.0f) {
            if (this.doesExplode()) {
                this.spawnExplosionCause();
                this.causeExplosion();
                this.turnFurnaceOff();
            }
        } else {
            this.ticksRunning = 0;
        }
        this.processItems();
        this.m_6596_();
        this.toggleLid(true);
        this.setCampfireLit(true);
    }

    private void turnFurnaceOff() {
        this.heat = 0.0f;
        this.ticksRunning = 0;
        this.resetFuel();
        this.toggleLid(false);
        this.setCampfireLit(false);
    }

    private void toggleLid(boolean lightUp) {
        boolean isLit;
        boolean wasLit = (Boolean)this.m_58900_().m_61143_((Property)FurnaceControllerBlock.LIT);
        if (wasLit != (isLit = lightUp)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FurnaceControllerBlock.LIT, (Comparable)Boolean.valueOf(isLit)), 3);
        }
    }

    private boolean doesExplode() {
        float baseChance = 2.0E-4f;
        ++this.ticksRunning;
        float chance = baseChance * (float)this.ticksRunning;
        return this.f_58857_.f_46441_.m_188501_() < chance;
    }

    private void spawnExplosionCause() {
        ArmorStand dummy = (ArmorStand)EntityType.f_20529_.m_20615_(this.f_58857_);
        if (dummy != null) {
            dummy.m_6842_(true);
            dummy.m_20331_(true);
            dummy.m_6593_((Component)Component.m_237113_((String)"Furnace"));
            dummy.m_20340_(false);
            dummy.m_6027_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5);
            this.f_58857_.m_7967_((Entity)dummy);
            this.f_58857_.m_254849_((Entity)dummy, (double)this.f_58858_.m_7918_(0, 0, 0).m_123341_(), (double)this.f_58858_.m_7918_(0, 2, 0).m_123342_(), (double)this.f_58858_.m_7918_(0, 0, 1).m_123343_(), 6.0f, Level.ExplosionInteraction.BLOCK);
            dummy.m_146870_();
        }
    }

    private void causeExplosion() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemStack drop = stack.m_41777_();
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
            double dx = (double)this.f_58858_.m_123341_() + 0.5;
            double dy = (double)this.f_58858_.m_123342_() + 0.5;
            double dz = (double)this.f_58858_.m_123343_() + 0.5;
            ItemEntity entity = new ItemEntity(this.f_58857_, dx, dy, dz, drop);
            if (this.f_58857_.f_46441_.m_188503_(100) < 75) {
                double spread = 8.0;
                double motionX = (this.f_58857_.f_46441_.m_188500_() - 0.5) * spread * 2.0;
                double motionY = this.f_58857_.f_46441_.m_188500_() * 0.5 + 0.2;
                double motionZ = (this.f_58857_.f_46441_.m_188500_() - 0.5) * spread * 2.0;
                entity.m_20334_(motionX, motionY, motionZ);
            }
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    private float calculateNewHeat(float heat, boolean isBurning) {
        heat = this.checkDoorClosed() ? (isBurning ? (heat += this.heatIncreaseCalculation(12.0f, this.activeFuel) + this.heatDecreaseCalculation(1.0f) * 5.0f) : (heat += this.heatDecreaseCalculation(1.0f) * 5.0f)) : (isBurning ? (heat += this.heatIncreaseCalculation(1.0f, this.activeFuel) + this.heatDecreaseCalculation(20.0f) * 5.0f) : (heat += this.heatDecreaseCalculation(20.0f) * 5.0f));
        return Mth.m_14036_((float)heat, (float)0.0f, (float)1800.0f);
    }

    private float heatIncreaseCalculation(float multiplier, ItemStack fuel) {
        float normalized = (this.heat - 0.0f) / 1800.0f;
        float exponent = 1.0f;
        float factor = (float)Math.pow(1.0f - normalized, exponent);
        return FurnaceFuelRegistry.getHeatStrength(fuel) * factor * multiplier;
    }

    private float heatDecreaseCalculation(float multiplier) {
        float factor = (this.heat - 0.0f) / 1800.0f;
        return -0.15f * factor * multiplier;
    }

    private boolean checkDoorClosed() {
        BlockState state = this.m_58900_();
        Direction facing = state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) ? (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) : Direction.NORTH;
        BlockPos temp = FurnaceMultiblockRenderer.rotateOffset(new OffsetBlock(0, 3, 1, List.of(Blocks.f_50216_), state), this.f_58858_, facing);
        assert (this.f_58857_ != null);
        BlockState doorState = this.f_58857_.m_8055_(temp);
        return doorState.m_60734_() instanceof TrapDoorBlock && (Boolean)doorState.m_61143_((Property)DoorBlock.f_52727_) == false;
    }

    private void setCampfireLit(boolean lit) {
        boolean currentlyLit;
        BlockState state = this.m_58900_();
        Direction facing = state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) ? (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) : Direction.NORTH;
        BlockPos campfirePos = FurnaceMultiblockRenderer.rotateOffset(new OffsetBlock(0, 0, 1, List.of(Blocks.f_50683_, Blocks.f_50684_), state), this.f_58858_, facing);
        assert (this.f_58857_ != null);
        BlockState campfireState = this.f_58857_.m_8055_(campfirePos);
        if (campfireState.m_60734_() instanceof CampfireBlock && (currentlyLit = ((Boolean)campfireState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) != lit) {
            this.f_58857_.m_7731_(campfirePos, (BlockState)campfireState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(lit)), 3);
        }
    }

    private void processItems() {
        for (int i = 0; i < 8; ++i) {
            ItemStack input = this.itemHandler.getStackInSlot(i);
            if (this.lastItems[i] == null) {
                this.lastItems[i] = ItemStack.f_41583_;
            }
            if (!ItemStack.m_41728_((ItemStack)input, (ItemStack)this.lastItems[i])) {
                this.progress[i] = 0.0f;
                this.lastItems[i] = input.m_41777_();
                continue;
            }
            if (input.m_41619_()) {
                this.progress[i] = 0.0f;
                continue;
            }
            Optional<Realistic_Furnace_Recipe> recipeOpt = this.getRecipeForSlot(input);
            if (recipeOpt.isEmpty()) {
                this.progress[i] = 0.0f;
                this.stalled[i] = true;
                continue;
            }
            Realistic_Furnace_Recipe recipe = recipeOpt.get();
            float percentageOfRequiredHeat = this.heat / (float)recipe.getRequiredHeat();
            float reachableProgress = 1000.0f * percentageOfRequiredHeat;
            if (percentageOfRequiredHeat >= 1.5f && this.progress[i] >= 500.0f) {
                this.itemHandler.extractItem(i, 1, false);
                ItemStack overheated = recipe.getOverheatedResult(this.f_58857_.m_9598_());
                if (overheated != null && !overheated.m_41619_()) {
                    this.itemHandler.insertItem(i, overheated.m_41777_(), false);
                }
                this.progress[i] = 0.0f;
                this.stalled[i] = true;
                continue;
            }
            if (this.progress[i] < reachableProgress && (double)percentageOfRequiredHeat >= 0.8) {
                int n = i;
                this.progress[n] = this.progress[n] + 1.0f * percentageOfRequiredHeat * 5.0f;
                this.stalled[i] = false;
            } else if (this.progress[i] > 0.0f) {
                if (this.progress[i] - 2.5f < reachableProgress) {
                    this.progress[i] = reachableProgress;
                } else {
                    int n = i;
                    this.progress[n] = this.progress[n] - 2.5f;
                }
                this.stalled[i] = true;
                continue;
            }
            this.progress[i] = Math.max(0.0f, Math.min(this.progress[i], 1000.0f));
            if (!(this.progress[i] >= 1000.0f)) continue;
            this.itemHandler.extractItem(i, 1, false);
            assert (this.f_58857_ != null);
            this.itemHandler.insertItem(i, recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_(), false);
            this.progress[i] = 0.0f;
            this.stalled[i] = false;
        }
    }

    private Optional<Realistic_Furnace_Recipe> getRecipeForSlot(ItemStack stack) {
        if (this.f_58857_ == null || stack.m_41619_()) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer(1);
        container.m_6836_(0, stack);
        return this.f_58857_.m_7465_().m_44015_((RecipeType)Realistic_Furnace_Recipe.Type.INSTANCE, (Container)container, this.f_58857_);
    }

    private void smeltItem(int slot) {
        Optional<Realistic_Furnace_Recipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.itemHandler.extractItem(slot, 1, false);
        this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(slot).m_41613_() + result.m_41613_()));
    }

    private boolean hasRecipe() {
        Optional<Realistic_Furnace_Recipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(null);
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    private void resetFuel() {
        this.burnTime = 0;
        this.burnTimeTotal = 0;
        this.activeFuel = ItemStack.f_41583_;
        this.m_6596_();
    }

    private Optional<Realistic_Furnace_Recipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)Realistic_Furnace_Recipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    public void toggleGhostMode() {
        this.ghostMode = this.ghostMode.next();
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public GhostMode getGhostMode() {
        return this.ghostMode;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        tag.m_128350_("Heat", this.heat);
        tag.m_128405_("MaxHeat", 1800);
        tag.m_128405_("BurnTime", this.burnTime);
        tag.m_128405_("BurnTimeTotal", this.burnTimeTotal);
        tag.m_128365_("ActiveFuel", (Tag)this.activeFuel.m_41739_(new CompoundTag()));
        for (int i = 0; i < this.progress.length; ++i) {
            tag.m_128350_("Progress" + i, this.progress[i]);
            tag.m_128379_("Stalled" + i, this.stalled[i]);
        }
        tag.m_128359_("GhostMode", this.ghostMode.name());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        this.heat = tag.m_128457_("Heat");
        this.burnTime = tag.m_128451_("BurnTime");
        this.burnTimeTotal = tag.m_128451_("BurnTimeTotal");
        this.activeFuel = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ActiveFuel"));
        for (int i = 0; i < this.progress.length; ++i) {
            this.progress[i] = tag.m_128457_("Progress" + i);
            this.stalled[i] = tag.m_128471_("Stalled" + i);
        }
        if (tag.m_128441_("GhostMode")) {
            try {
                this.ghostMode = GhostMode.valueOf(tag.m_128461_("GhostMode"));
            }
            catch (IllegalArgumentException e) {
                this.ghostMode = GhostMode.BLOCK_BY_BLOCK;
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public static enum GhostMode {
        BLOCK_BY_BLOCK,
        FULL_STRUCTURE,
        NONE;


        public GhostMode next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case BLOCK_BY_BLOCK -> FULL_STRUCTURE;
                case FULL_STRUCTURE -> NONE;
                case NONE -> BLOCK_BY_BLOCK;
            };
        }
    }
}

