/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.client.renderer;

import com.fireblaze.realistic_furnace.blockentities.FurnaceControllerBlockEntity;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRenderer;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="realistic_furnace", value={Dist.CLIENT})
public class FurnaceGhostRenderer {
    private static final List<FurnaceControllerBlockEntity> ACTIVE_CONTROLLERS = new ArrayList<FurnaceControllerBlockEntity>();
    private static final Map<FurnaceControllerBlockEntity, Integer> ghostIndices = new HashMap<FurnaceControllerBlockEntity, Integer>();

    public static void register(FurnaceControllerBlockEntity be) {
        if (!ACTIVE_CONTROLLERS.contains((Object)be)) {
            ACTIVE_CONTROLLERS.add(be);
        }
    }

    public static void unregister(FurnaceControllerBlockEntity be) {
        ACTIVE_CONTROLLERS.remove((Object)be);
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        for (FurnaceControllerBlockEntity controller : new ArrayList<FurnaceControllerBlockEntity>(ACTIVE_CONTROLLERS)) {
            BlockPos origin;
            List<OffsetBlock> missing;
            FurnaceControllerBlockEntity.GhostMode mode = controller.getGhostMode();
            if (mode == FurnaceControllerBlockEntity.GhostMode.BLOCK_BY_BLOCK) {
                if (!controller.shouldRenderGhost() || controller.m_58901_() || controller.m_58904_() != level) continue;
                controller.updateGhostState((Level)level);
                if (!controller.shouldRenderGhost() || (missing = FurnaceMultiblockRenderer.getMissingBlocks((Level)level, origin = controller.m_58899_())).isEmpty()) continue;
                FurnaceGhostRenderer.renderGhosts(event, missing, origin, (Level)level, controller);
                continue;
            }
            if (mode == FurnaceControllerBlockEntity.GhostMode.FULL_STRUCTURE) {
                if (controller.m_58901_() || controller.m_58904_() != level || (missing = FurnaceMultiblockRenderer.getMissingBlocks((Level)level, origin = controller.m_58899_())).isEmpty()) continue;
                FurnaceGhostRenderer.renderFullStructure(event, missing, origin, (Level)level);
                continue;
            }
            return;
        }
    }

    private static void renderGhosts(RenderLevelStageEvent event, List<OffsetBlock> missing, BlockPos origin, Level level, FurnaceControllerBlockEntity controller) {
        if (missing.isEmpty()) {
            return;
        }
        int index = ghostIndices.getOrDefault((Object)controller, 0);
        if (index >= missing.size()) {
            return;
        }
        OffsetBlock nextGhost = missing.get(index);
        BlockPos pos = FurnaceMultiblockRenderer.rotateOffset(nextGhost, origin, level.m_8055_(origin).m_61145_((Property)HorizontalDirectionalBlock.f_54117_).orElse(Direction.NORTH));
        BlockState currentState = level.m_8055_(pos);
        BlockState expectedState = nextGhost.getStateTemplate();
        if (expectedState.m_60734_() instanceof StairBlock) {
            expectedState = FurnaceMultiblockRenderer.rotateStair(expectedState, level.m_8055_(origin).m_61145_((Property)HorizontalDirectionalBlock.f_54117_).orElse(Direction.NORTH));
        }
        boolean missingBlock = currentState.m_60795_();
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        poseStack.m_85836_();
        poseStack.m_85837_((double)pos.m_123341_() - camera.m_90583_().f_82479_, (double)pos.m_123342_() - camera.m_90583_().f_82480_, (double)pos.m_123343_() - camera.m_90583_().f_82481_);
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        if (missingBlock) {
            dispatcher.renderSingleBlock(expectedState, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110466_());
        }
        buffer.m_109911_();
        MultiBufferSource.BufferSource buffer2 = mc.m_91269_().m_110104_();
        VertexConsumer consumer = buffer.m_6299_(ModRenderTypes.GHOST_LINES);
        float r = missingBlock ? 0.0f : 1.0f;
        float g = missingBlock ? 0.6f : 0.0f;
        float b = missingBlock ? 0.6f : 0.0f;
        float a = 0.5f;
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)r, (float)g, (float)b, (float)a);
        buffer2.m_109912_(ModRenderTypes.GHOST_LINES);
        poseStack.m_85849_();
    }

    private static void renderFullStructure(RenderLevelStageEvent event, List<OffsetBlock> missing, BlockPos origin, Level level) {
        if (missing.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        PoseStack poseStack = event.getPoseStack();
        Camera camera = event.getCamera();
        for (OffsetBlock offset : missing) {
            boolean missingBlock;
            BlockPos pos = FurnaceMultiblockRenderer.rotateOffset(offset, origin, level.m_8055_(origin).m_61145_((Property)HorizontalDirectionalBlock.f_54117_).orElse(Direction.NORTH));
            BlockState currentState = level.m_8055_(pos);
            BlockState expectedState = offset.getStateTemplate();
            if (expectedState.m_60734_() instanceof StairBlock) {
                expectedState = FurnaceMultiblockRenderer.rotateStair(expectedState, level.m_8055_(origin).m_61145_((Property)HorizontalDirectionalBlock.f_54117_).orElse(Direction.NORTH));
            }
            if (!(missingBlock = currentState.m_60795_())) continue;
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_() - camera.m_90583_().f_82479_, (double)pos.m_123342_() - camera.m_90583_().f_82480_, (double)pos.m_123343_() - camera.m_90583_().f_82481_);
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            dispatcher.renderSingleBlock(expectedState, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110466_());
            buffer.m_109911_();
            poseStack.m_85849_();
        }
    }

    public static class ModRenderTypes
    extends RenderType {
        public static final RenderType GHOST_LINES = RenderType.m_173215_((String)"ghost_lines", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110685_(f_110139_).m_110663_(f_110111_).m_110661_(f_110110_).m_110687_(f_110115_).m_110691_(false));

        private ModRenderTypes(String name, VertexFormat format, VertexFormat.Mode mode, int bufSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setup, Runnable clear) {
            super(name, format, mode, bufSize, affectsCrumbling, sortOnUpload, setup, clear);
        }
    }
}

