/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.compat;

import com.fireblaze.realistic_furnace.blocks.ModBlocks;
import com.fireblaze.realistic_furnace.compat.CustomProgressDrawable;
import com.fireblaze.realistic_furnace.compat.HeatBarDrawable;
import com.fireblaze.realistic_furnace.recipe.Realistic_Furnace_Recipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FurnaceRecipeCategory
implements IRecipeCategory<Realistic_Furnace_Recipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"realistic_furnace", (String)"furnace_smelting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"realistic_furnace", (String)"textures/gui/realistic_furnace_gui.png");
    public static final RecipeType<Realistic_Furnace_Recipe> REALISTIC_FURNACE_TYPE = new RecipeType(UID, Realistic_Furnace_Recipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable progressAnimated;
    private final IDrawableStatic flameStatic;
    private final IDrawableAnimated flameAnimated;

    public FurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FURNACE_CONTROLLER.get()));
        this.progressAnimated = new CustomProgressDrawable(18, 1);
        this.flameStatic = guiHelper.createDrawable(TEXTURE, 176, 0, 14, 14);
        this.flameAnimated = guiHelper.createAnimatedDrawable(this.flameStatic, 300, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<Realistic_Furnace_Recipe> getRecipeType() {
        return REALISTIC_FURNACE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.realistic_furnace.furnace_controller");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Realistic_Furnace_Recipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 46, 21).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 68, 21).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 68, 48).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 92, 48).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 46, 48).addItemStack(recipe.m_8043_(null));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 21).addItemStack(recipe.m_8043_(null));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 114, 21).addItemStack(recipe.m_8043_(null));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 114, 48).addItemStack(recipe.m_8043_(null));
    }

    public void draw(Realistic_Furnace_Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        int[][] positions;
        for (int[] pos : positions = new int[][]{{45, 18}, {67, 18}, {67, 45}, {91, 45}}) {
            this.progressAnimated.draw(gui, pos[0], pos[1]);
        }
        int heatBarX = 150;
        int heatBarY = 9;
        int heatBarWidth = 8;
        int heatBarHeight = 64;
        int requiredHeat = recipe.getRequiredHeat();
        HeatBarDrawable heatBar = new HeatBarDrawable(heatBarWidth, heatBarHeight, requiredHeat, 1800);
        heatBar.draw(gui, heatBarX, heatBarY);
        if (mouseX >= (double)heatBarX && mouseX < (double)(heatBarX + heatBarWidth) && mouseY >= (double)heatBarY && mouseY < (double)(heatBarY + heatBarHeight)) {
            Font font = Minecraft.m_91087_().f_91062_;
            gui.m_280557_(font, (Component)Component.m_237113_((String)(requiredHeat + "\u00b0C")), (int)mouseX, (int)mouseY);
        }
        int flameX = 15;
        int flameY = 17;
        this.flameAnimated.draw(gui, flameX, flameY);
    }
}

