/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.containers;

import com.fireblaze.realistic_furnace.blockentities.FurnaceControllerBlockEntity;
import com.fireblaze.realistic_furnace.containers.ModMenuTypes;
import com.fireblaze.realistic_furnace.fuel.FurnaceFuelRegistry;
import com.fireblaze.realistic_furnace.recipe.Realistic_Furnace_Recipe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FurnaceContainer
extends AbstractContainerMenu {
    private final FurnaceControllerBlockEntity blockEntity;
    private final IItemHandler itemHandler;
    private final ContainerData progressData;
    private final ContainerData heatData;
    private final ContainerData burnTimeData;
    private final List<Realistic_Furnace_Recipe> recipes;

    public FurnaceContainer(int id, Inventory playerInventory, final FurnaceControllerBlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.FURNACE.get(), id);
        this.blockEntity = blockEntity;
        this.itemHandler = blockEntity.getItemHandler();
        if (!playerInventory.f_35978_.m_9236_().f_46443_) {
            RecipeManager recipeManager = playerInventory.f_35978_.m_9236_().m_7465_();
            this.recipes = recipeManager.m_44013_((RecipeType)Realistic_Furnace_Recipe.Type.INSTANCE);
        } else {
            this.recipes = Collections.emptyList();
        }
        this.progressData = new ContainerData(){

            public int m_6413_(int index) {
                int slot = index / 2;
                int type = index % 2;
                if (slot >= 0 && slot < blockEntity.getProgress().length) {
                    return switch (type) {
                        case 0 -> (int)(blockEntity.getProgress()[slot] * 100.0f);
                        case 1 -> {
                            if (blockEntity.isStalled(slot)) {
                                yield 1;
                            }
                            yield 0;
                        }
                        default -> 0;
                    };
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                int slot = index / 2;
                int type = index % 2;
                if (slot >= 0 && slot < blockEntity.getProgress().length) {
                    if (type == 0) {
                        blockEntity.getProgress()[slot] = (float)value / 100.0f;
                    } else if (type == 1) {
                        blockEntity.setStalled(slot, value != 0);
                    }
                }
            }

            public int m_6499_() {
                return blockEntity.getProgress().length * 2;
            }
        };
        this.heatData = blockEntity.getHeatData();
        this.burnTimeData = blockEntity.getBurnTimeData();
        this.m_38884_(this.progressData);
        this.m_38884_(this.heatData);
        this.m_38884_(this.burnTimeData);
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 0, 46, 21));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 1, 46, 48));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 2, 68, 21));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 3, 68, 48));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 4, 92, 21));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 5, 92, 48));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 6, 114, 21));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 7, 114, 48));
        this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, 8, 15, 34));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public FurnaceContainer(int id, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(id, playerInventory, (FurnaceControllerBlockEntity)Objects.requireNonNull(playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_())));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = this.m_38853_(index).m_7993_();
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = stack.m_41777_();
        boolean moved = false;
        if (index < 9) {
            if (!this.m_38903_(stack, 9, 36, true)) {
                return ItemStack.f_41583_;
            }
        } else {
            for (Realistic_Furnace_Recipe recipe : this.recipes) {
                for (Ingredient ingredient : recipe.m_7527_()) {
                    if (!ingredient.test(stack)) continue;
                    moved = this.m_38903_(stack, 0, 8, false);
                    break;
                }
                if (!moved) continue;
                break;
            }
            if (!moved && FurnaceFuelRegistry.isFuel(stack)) {
                moved = this.m_38903_(stack, 8, 9, false);
            }
            if (!moved) {
                return ItemStack.f_41583_;
            }
        }
        if (stack.m_41619_()) {
            this.m_38853_(index).m_5852_(ItemStack.f_41583_);
        } else {
            this.m_38853_(index).m_6654_();
        }
        return copy;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity != null && !this.blockEntity.m_58901_();
    }

    public FurnaceControllerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ContainerData getProgressData() {
        return this.progressData;
    }

    public ContainerData getHeatData() {
        return this.heatData;
    }

    public ContainerData getBurnTimeData() {
        return this.burnTimeData;
    }
}

