/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.fuel;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class FurnaceFuelRegistry {
    private static final Map<Item, FuelData> ITEM_FUEL = new HashMap<Item, FuelData>();

    public static void register(Item item, int burnTime, float heatStrength) {
        ITEM_FUEL.put(item, new FuelData(burnTime, heatStrength));
    }

    public static void register(TagKey<Item> tag, int burnTime, float heatStrength) {
        int count = 0;
        for (Item item : ForgeRegistries.ITEMS) {
            if (!item.m_204114_().m_203656_(tag)) continue;
            ITEM_FUEL.put(item, new FuelData(burnTime, heatStrength));
            ++count;
        }
    }

    public static boolean isFuel(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return ITEM_FUEL.containsKey(stack.m_41720_());
    }

    public static int getBurnTime(ItemStack stack) {
        FuelData data = ITEM_FUEL.get(stack.m_41720_());
        return data != null ? data.burnTime() : 0;
    }

    public static float getHeatStrength(ItemStack stack) {
        FuelData data = ITEM_FUEL.get(stack.m_41720_());
        return data != null ? data.heatStrength() : 0.0f;
    }

    public static void init() {
        FurnaceFuelRegistry.register(Items.f_42413_, 1600, 0.9f);
        FurnaceFuelRegistry.register(Items.f_42414_, 1600, 0.275f);
        FurnaceFuelRegistry.register(Items.f_42398_, 150, 0.05f);
        FurnaceFuelRegistry.register((TagKey<Item>)ItemTags.f_13168_, 300, 0.2f);
    }

    public record FuelData(int burnTime, float heatStrength) {
    }
}

