/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.multiblock;

import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblock;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class FurnaceMultiblockRenderer {
    public static List<OffsetBlock> getMissingBlocks(Level level, BlockPos origin) {
        ArrayList<OffsetBlock> missing = new ArrayList<OffsetBlock>();
        BlockState controllerState = level.m_8055_(origin);
        Direction facing = controllerState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) ? (Direction)controllerState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) : Direction.NORTH;
        for (OffsetBlock offset : FurnaceMultiblock.STRUCTURE) {
            BlockPos rotatedPos = FurnaceMultiblockRenderer.rotateOffset(offset, origin, facing);
            Block block = level.m_8055_(rotatedPos).m_60734_();
            BlockState currentState = level.m_8055_(rotatedPos);
            BlockState expectedState = offset.getStateTemplate();
            if (expectedState.m_60734_() instanceof StairBlock && !currentState.equals(expectedState = FurnaceMultiblockRenderer.rotateStair(expectedState, facing))) {
                missing.add(offset);
            }
            if (offset.matcher().test(block)) continue;
            missing.add(offset);
        }
        return missing;
    }

    public static BlockPos rotateOffset(OffsetBlock offset, BlockPos origin, Direction facing) {
        int x = offset.x();
        int y = offset.y();
        int z = offset.z();
        return switch (facing) {
            case Direction.NORTH -> origin.m_7918_(x, y, z);
            case Direction.SOUTH -> origin.m_7918_(-x, y, -z);
            case Direction.WEST -> origin.m_7918_(z, y, -x);
            case Direction.EAST -> origin.m_7918_(-z, y, x);
            default -> origin.m_7918_(x, y, z);
        };
    }

    public static BlockState rotateStair(BlockState template, Direction controllerFacing) {
        Direction original = (Direction)template.m_61143_((Property)StairBlock.f_56841_);
        Direction rotated = FurnaceMultiblockRenderer.rotateDirection(original, controllerFacing);
        return (BlockState)((BlockState)((BlockState)template.m_61124_((Property)StairBlock.f_56841_, (Comparable)rotated)).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)template.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)template.m_61143_((Property)StairBlock.f_56843_)));
    }

    private static Direction rotateDirection(Direction original, Direction controllerFacing) {
        int originalIndex = original.m_122416_();
        int controllerIndex = controllerFacing.m_122416_();
        int newIndex = (originalIndex + controllerIndex) % 4;
        return Direction.m_122407_((int)newIndex);
    }
}

