/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Realistic_Furnace_Recipe
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int requiredHeat;
    private final ItemStack overheatedResult;

    public Realistic_Furnace_Recipe(NonNullList<Ingredient> inputItems, ItemStack output, ResourceLocation id, int requiredHeat, ItemStack overheatedResult) {
        this.inputItems = inputItems;
        this.output = output;
        this.id = id;
        this.requiredHeat = requiredHeat;
        this.overheatedResult = overheatedResult;
    }

    public int getRequiredHeat() {
        return this.requiredHeat;
    }

    @Nullable
    public ItemStack getOverheatedResult(RegistryAccess registryAccess) {
        return this.overheatedResult == null ? ItemStack.f_41583_ : this.overheatedResult;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        if (container.m_7983_()) {
            return false;
        }
        ItemStack stack = container.m_8020_(0);
        if (stack.m_41619_()) {
            return false;
        }
        return this.inputItems.stream().anyMatch(ingredient -> ingredient.test(stack));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<Realistic_Furnace_Recipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"realistic_furnace", (String)"realistic_smelting");

        public Realistic_Furnace_Recipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            int requiredHeat = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"requiredHeat", (int)1000);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(0)));
            ItemStack overheatedResult = ItemStack.f_41583_;
            if (pSerializedRecipe.has("overheatedOutput")) {
                overheatedResult = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"overheatedOutput"));
            }
            return new Realistic_Furnace_Recipe((NonNullList<Ingredient>)inputs, output, pRecipeId, requiredHeat, overheatedResult);
        }

        @Nullable
        public Realistic_Furnace_Recipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            int requiredHeat = pBuffer.readInt();
            ItemStack overheatedResult = pBuffer.m_130267_();
            return new Realistic_Furnace_Recipe((NonNullList<Ingredient>)inputs, output, pRecipeId, requiredHeat, overheatedResult);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, Realistic_Furnace_Recipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputItems.size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            pBuffer.writeInt(pRecipe.getRequiredHeat());
            pBuffer.writeItemStack(Objects.requireNonNull(pRecipe.getOverheatedResult(null)), false);
        }
    }

    public static class Type
    implements RecipeType<Realistic_Furnace_Recipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "realistic_smelting";
    }
}

