/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace;

import com.fireblaze.realistic_furnace.blockentities.ModBlockEntities;
import com.fireblaze.realistic_furnace.blocks.ModBlocks;
import com.fireblaze.realistic_furnace.commands.DeleteMultiblockCommand;
import com.fireblaze.realistic_furnace.commands.RealisticFurnaceCommand;
import com.fireblaze.realistic_furnace.commands.RegisterTrapdoorCommand;
import com.fireblaze.realistic_furnace.commands.SaveMultiblockCommand;
import com.fireblaze.realistic_furnace.commands.SelectMultiblockCommand;
import com.fireblaze.realistic_furnace.config.RealisticFurnaceConfig;
import com.fireblaze.realistic_furnace.containers.ModMenuTypes;
import com.fireblaze.realistic_furnace.items.ModItems;
import com.fireblaze.realistic_furnace.networking.NetworkHandler;
import com.fireblaze.realistic_furnace.recipe.ModRecipes;
import com.fireblaze.realistic_furnace.screens.FurnaceScreen;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

@Mod(value="realistic_furnace")
public class RealisticFurnace {
    public static final String MODID = "realistic_furnace";
    private static final Logger LOGGER = LogUtils.getLogger();

    public RealisticFurnace(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        Path configDir = FMLPaths.CONFIGDIR.get().resolve(MODID);
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create config directory for Realistic Furnace", e);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RealisticFurnaceConfig.SPEC, configDir.resolve("realistic_furnace-common.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModMenuTypes.MENUS.register(modEventBus);
        ModRecipes.register(modEventBus);
        NetworkHandler.register();
    }

    public static void clientSetup(FMLClientSetupEvent event) {
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> RealisticFurnace.ensureDefaultMultiblockExists());
    }

    private static void ensureDefaultMultiblockExists() {
        Path folder = FMLPaths.CONFIGDIR.get().resolve("realistic_furnace/multiblocks");
        Path file = folder.resolve("original_furnace.json");
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
                try (InputStream in = RealisticFurnace.class.getResourceAsStream("/assets/realistic_furnace/multiblocks/original_furnace.json");){
                    if (in == null) {
                        LOGGER.error("[Realistic Furnace] Default multiblock JSON not found in resources!");
                        return;
                    }
                    Files.copy(in, file, StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.info("[Realistic Furnace] Default multiblock JSON created at " + String.valueOf(file));
                }
            }
            catch (IOException e) {
                LOGGER.error("[Realistic Furnace] Failed to create default multiblock JSON!", (Throwable)e);
            }
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.accept(ModItems.FURNACE_CONTROLLER_ITEM);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="realistic_furnace")
    public class RealisticFurnaceCommandRegistration {
        @SubscribeEvent
        public static void onCommandRegister(RegisterCommandsEvent event) {
            RealisticFurnaceCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            SaveMultiblockCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            SelectMultiblockCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            DeleteMultiblockCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
            RegisterTrapdoorCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    @Mod.EventBusSubscriber(modid="realistic_furnace", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.FURNACE.get()), FurnaceScreen::new);
        }
    }
}

