/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.blocks;

import com.fireblaze.realistic_furnace.blockentities.FurnaceControllerBlockEntity;
import com.fireblaze.realistic_furnace.blockentities.ModBlockEntities;
import com.fireblaze.realistic_furnace.client.FurnaceRenderState;
import com.fireblaze.realistic_furnace.containers.FurnaceContainer;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRenderer;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class FurnaceControllerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public FurnaceControllerBlock(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction playerFacing = context.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)playerFacing);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FurnaceControllerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != ModBlockEntities.FURNACE_CONTROLLER.get()) {
            return null;
        }
        return (lvl, pos, s, be) -> {
            if (!lvl.f_46443_) {
                ((FurnaceControllerBlockEntity)be).tick();
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof FurnaceControllerBlockEntity)) {
            return InteractionResult.PASS;
        }
        final FurnaceControllerBlockEntity furnaceBE = (FurnaceControllerBlockEntity)be;
        if (!level.f_46443_) {
            List<OffsetBlock> missing = FurnaceMultiblockRenderer.getMissingBlocks(level, pos);
            if (missing.isEmpty()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"Realistic Furnace");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
                        return new FurnaceContainer(id, inv, furnaceBE);
                    }
                }, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        List<OffsetBlock> missing = FurnaceMultiblockRenderer.getMissingBlocks(level, pos);
        if (!missing.isEmpty()) {
            FurnaceRenderState.toggleGhostRendering();
            FurnaceRenderState.cycleMode();
            FurnaceControllerBlockEntity.GhostMode mode = FurnaceRenderState.getMode();
            boolean active = mode != FurnaceControllerBlockEntity.GhostMode.NONE;
            FurnaceRenderState.setGhostRendering(active);
            if (!active) {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7cGhost Rendering Deactivated"), true);
            } else {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7aGhost Rendering: " + FurnaceControllerBlock.formatString(mode.toString()))), true);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static String formatString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        input = input.replace('_', ' ');
        input = input.toLowerCase();
        StringBuilder formatted = new StringBuilder();
        boolean capitalizeNext = true;
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) {
                formatted.append(c);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                formatted.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            formatted.append(c);
        }
        return formatted.toString();
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = player.m_21205_();
        return stack.m_41720_() instanceof PickaxeItem;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof FurnaceControllerBlockEntity) {
                FurnaceControllerBlockEntity furnaceBE = (FurnaceControllerBlockEntity)be;
                for (int i = 0; i < furnaceBE.getItemHandler().getSlots(); ++i) {
                    ItemStack stack = furnaceBE.getItemHandler().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188500_() < 0.1) {
            level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Direction.Axis axis = direction.m_122434_();
        double offset = 0.52;
        double dx = random.m_188500_() * 0.6 - 0.3;
        double dy = random.m_188500_() * 6.0 / 16.0;
        double dz = random.m_188500_() * 0.6 - 0.3;
        switch (axis) {
            case X: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (double)direction.m_122429_() * offset, y + dy, z + dz, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + (double)direction.m_122429_() * offset, y + dy, z + dz, 0.0, 0.0, 0.0);
                break;
            }
            case Z: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + dx, y + dy, z + (double)direction.m_122431_() * offset, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + dx, y + dy, z + (double)direction.m_122431_() * offset, 0.0, 0.0, 0.0);
            }
        }
    }
}

