/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.client;

import com.fireblaze.realistic_furnace.blockentities.FurnaceControllerBlockEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.Level;

public class FurnaceRenderState {
    private static final Map<UUID, Boolean> ghostRendering = new HashMap<UUID, Boolean>();
    private static final Map<UUID, FurnaceControllerBlockEntity.GhostMode> modes = new HashMap<UUID, FurnaceControllerBlockEntity.GhostMode>();
    private static final Map<UUID, Level> worlds = new HashMap<UUID, Level>();
    private static final Map<UUID, String> multiblockNames = new HashMap<UUID, String>();

    public static boolean isGhostRendering() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        return ghostRendering.getOrDefault(player.m_20148_(), false);
    }

    public static void toggleGhostRendering() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean newValue = ghostRendering.getOrDefault(player.m_20148_(), false) == false;
        ghostRendering.put(player.m_20148_(), newValue);
    }

    public static void setGhostRendering(boolean value) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ghostRendering.put(player.m_20148_(), value);
    }

    public static FurnaceControllerBlockEntity.GhostMode getMode() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return FurnaceControllerBlockEntity.GhostMode.NONE;
        }
        return modes.getOrDefault(player.m_20148_(), FurnaceControllerBlockEntity.GhostMode.BLOCK_BY_BLOCK);
    }

    public static void setMode(FurnaceControllerBlockEntity.GhostMode mode) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        modes.put(player.m_20148_(), mode);
    }

    public static void cycleMode() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        FurnaceControllerBlockEntity.GhostMode current = FurnaceRenderState.getMode();
        FurnaceControllerBlockEntity.GhostMode next = switch (current) {
            default -> throw new IncompatibleClassChangeError();
            case FurnaceControllerBlockEntity.GhostMode.NONE -> FurnaceControllerBlockEntity.GhostMode.BLOCK_BY_BLOCK;
            case FurnaceControllerBlockEntity.GhostMode.BLOCK_BY_BLOCK -> FurnaceControllerBlockEntity.GhostMode.FULL_STRUCTURE;
            case FurnaceControllerBlockEntity.GhostMode.FULL_STRUCTURE -> FurnaceControllerBlockEntity.GhostMode.NONE;
        };
        modes.put(player.m_20148_(), next);
    }

    public static void setWorld(Level world) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        worlds.put(player.m_20148_(), world);
    }

    public static Level getWorld() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        return worlds.get(player.m_20148_());
    }

    public static void setMultiblock(String name) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        multiblockNames.put(player.m_20148_(), name);
    }

    public static String getMultiblock() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return null;
        }
        return multiblockNames.get(player.m_20148_());
    }
}

