/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.commands;

import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.MultiblockUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLPaths;

public class DeleteMultiblockCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"realistic_furnace").then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            Path folder = FMLPaths.CONFIGDIR.get().resolve("realistic_furnace/multiblocks");
            try (Stream<Path> files = Files.list(folder);){
                files.filter(f -> f.toString().endsWith(".json")).forEach(f -> builder.suggest(f.getFileName().toString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return builder.buildFuture();
        }).executes(ctx -> DeleteMultiblockCommand.deleteMultiblock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))));
    }

    private static int deleteMultiblock(CommandSourceStack source, String name) {
        Path folder = FMLPaths.CONFIGDIR.get().resolve("realistic_furnace/multiblocks");
        Path file = folder.resolve(name);
        if (!Files.exists(file, new LinkOption[0])) {
            source.m_81352_((Component)Component.m_237113_((String)("File not found: " + name)));
            return 0;
        }
        if (name.equalsIgnoreCase(MultiblockUtils.getFallbackFile())) {
            source.m_81352_((Component)Component.m_237113_((String)"The fallback multiblock cannot be deleted!"));
            return 0;
        }
        if (name.equals(FurnaceMultiblockRegistry.getSelectedMultiblockName((Level)source.m_81372_()))) {
            source.m_81352_((Component)Component.m_237113_((String)"This multiblock is currently selected. Select another multiblock before deleting this one"));
            return 0;
        }
        try {
            Files.delete(file);
            source.m_288197_(() -> Component.m_237113_((String)("multiblock '" + name + "' got successfully deleted!")), false);
        }
        catch (IOException e) {
            source.m_81352_((Component)Component.m_237113_((String)("Exception: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
        return 1;
    }
}

