/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.commands;

import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.MultiblockScanner;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class RealisticFurnaceCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"realistic_furnace").then(Commands.m_82127_((String)"scan").executes(context -> RealisticFurnaceCommand.scanStructure((CommandSourceStack)context.getSource()))));
    }

    private static int scanStructure(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof Player)) {
            source.m_81352_((Component)Component.m_237113_((String)"Only players can execute this command"));
            return 1;
        }
        Player player = (Player)entity;
        Level world = player.m_9236_();
        HitResult hitResult = player.m_19907_(10.0, 0.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            source.m_81352_((Component)Component.m_237113_((String)"You are not facing a block or the block is too far"));
            return 1;
        }
        BlockPos controllerPos = ((BlockHitResult)hitResult).m_82425_();
        List<OffsetBlock> found = MultiblockScanner.scanFromController(source, world, controllerPos);
        if (found.isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)"No connected blocks found!"));
            FurnaceMultiblockRegistry.setHasValve(world, false);
            return 1;
        }
        source.m_288197_(() -> Component.m_237113_((String)"=== Realistic Furnace Multiblock Scan ==="), false);
        found.stream().collect(Collectors.groupingBy(OffsetBlock::getBlockName, Collectors.counting())).forEach((name, count) -> source.m_288197_(() -> Component.m_237113_((String)(name + ": " + count)), false));
        List<OffsetBlock> trapdoors = found.stream().filter(b -> b.getStateTemplate().m_60734_().m_204297_().m_203656_(BlockTags.f_13036_)).toList();
        if (trapdoors.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u26a0 No valve found! Add at least one trapdoor."));
            FurnaceMultiblockRegistry.clearValve(world);
            FurnaceMultiblockRegistry.setHasValve(world, false);
        } else if (trapdoors.size() > 1) {
            player.m_213846_((Component)Component.m_237113_((String)"\u26a0 Multiple trapdoors found! Choose a valve with: /realistic_furnace registerTrapdoor <x> <y> <z>"));
            FurnaceMultiblockRegistry.setPendingVentSelection(trapdoors);
            FurnaceMultiblockRegistry.setHasValve(world, false);
            trapdoors.forEach(td -> source.m_288197_(() -> Component.m_237113_((String)(td.getBlockName() + " [offset: " + td.x() + ", " + td.y() + ", " + td.z() + "]")), false));
        } else {
            FurnaceMultiblockRegistry.setValve(world, trapdoors.get(0));
            FurnaceMultiblockRegistry.setHasValve(world, true);
        }
        source.m_288197_(() -> Component.m_237113_((String)("Total: " + found.size() + " blocks")), false);
        return 1;
    }
}

