/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.commands;

import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrapDoorBlock;

public class RegisterTrapdoorCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"realistic_furnace").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"registerTrapdoor").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
            int y = IntegerArgumentType.getInteger((CommandContext)context, (String)"y");
            int z = IntegerArgumentType.getInteger((CommandContext)context, (String)"z");
            OffsetBlock playerOffset = new OffsetBlock(x, y, z, block -> block instanceof TrapDoorBlock, null);
            List<OffsetBlock> allowed = FurnaceMultiblockRegistry.getPendingVentSelection();
            if (allowed == null || allowed.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)"No trapdoor available. Scan a multiblock first."));
                return 0;
            }
            boolean valid = allowed.stream().anyMatch(off -> off.x() == playerOffset.x() && off.y() == playerOffset.y() && off.z() == playerOffset.z());
            if (!valid) {
                source.m_81352_((Component)Component.m_237113_((String)"No trapdoor found. Select a displayed offset."));
                return 0;
            }
            FurnaceMultiblockRegistry.setValve((Level)source.m_81372_(), playerOffset);
            source.m_288197_(() -> Component.m_237113_((String)("Valve position registered: " + x + ", " + y + ", " + z)), true);
            return 1;
        }))))));
    }
}

