/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.commands;

import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.MultiblockScanner;
import com.fireblaze.realistic_furnace.multiblock.SerializableOffsetBlock;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLPaths;

public class SaveMultiblockCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"realistic_furnace").then(Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> SaveMultiblockCommand.saveMultiblock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))));
    }

    private static int saveMultiblock(CommandSourceStack source, String name) {
        if (MultiblockScanner.LAST_SCAN.isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u26a0 No scan found!"));
            return 0;
        }
        if (!FurnaceMultiblockRegistry.hasValve((Level)source.m_81372_())) {
            source.m_81352_((Component)Component.m_237113_((String)"\u26a0 No valve (trapdoor) detected!"));
            return 0;
        }
        Path folder = FMLPaths.CONFIGDIR.get().resolve("realistic_furnace/multiblocks");
        try {
            Files.createDirectories(folder, new FileAttribute[0]);
            ServerLevel world = source.m_81372_();
            if (!FurnaceMultiblockRegistry.hasValve((Level)world) || FurnaceMultiblockRegistry.getValve((Level)world) == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Please set a valve (trapdoor) before saving"));
                return 0;
            }
            Path file = folder.resolve(name + ".json");
            int counter = 1;
            while (Files.exists(file, new LinkOption[0])) {
                file = folder.resolve(name + "(" + counter + ").json");
                ++counter;
            }
            List<SerializableOffsetBlock> serializable = MultiblockScanner.LAST_SCAN.stream().map(SerializableOffsetBlock::new).toList();
            JsonObject root = new JsonObject();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            root.add("blocks", gson.toJsonTree(serializable));
            JsonObject valveJson = new JsonObject();
            valveJson.addProperty("x", (Number)FurnaceMultiblockRegistry.getValve((Level)world).x());
            valveJson.addProperty("y", (Number)FurnaceMultiblockRegistry.getValve((Level)world).y());
            valveJson.addProperty("z", (Number)FurnaceMultiblockRegistry.getValve((Level)world).z());
            root.add("valve", (JsonElement)valveJson);
            Files.writeString(file, (CharSequence)gson.toJson((JsonElement)root), new OpenOption[0]);
            Path finalFile = file;
            source.m_288197_(() -> Component.m_237113_((String)("Multiblock saved: " + String.valueOf(finalFile))), false);
        }
        catch (IOException e) {
            source.m_81352_((Component)Component.m_237113_((String)("Couldn't save file: " + e.getMessage())));
            e.printStackTrace();
        }
        return 1;
    }
}

