/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.commands;

import com.fireblaze.realistic_furnace.blockentities.FurnaceControllerBlockEntity;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.fireblaze.realistic_furnace.multiblock.SerializableOffsetBlock;
import com.fireblaze.realistic_furnace.networking.NetworkHandler;
import com.fireblaze.realistic_furnace.networking.packet.SyncMultiblockDataPacket;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.PacketDistributor;

public class SelectMultiblockCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"realistic_furnace").then(Commands.m_82127_((String)"select").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            Path folder = FMLPaths.CONFIGDIR.get().resolve("realistic_furnace/multiblocks");
            try (Stream<Path> files = Files.list(folder);){
                files.filter(f -> f.toString().endsWith(".json")).forEach(f -> builder.suggest(f.getFileName().toString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return builder.buildFuture();
        }).executes(ctx -> SelectMultiblockCommand.selectMultiblock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))));
    }

    public static int selectMultiblock(CommandSourceStack source, String name) {
        Path file = FMLPaths.CONFIGDIR.get().resolve("realistic_furnace/multiblocks/" + name);
        if (!Files.exists(file, new LinkOption[0])) {
            source.m_81352_((Component)Component.m_237113_((String)("File not found: " + name)));
            return 0;
        }
        try {
            String json = Files.readString(file);
            JsonElement rootElement = JsonParser.parseString((String)json);
            ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
            Gson gson = new Gson();
            if (rootElement.isJsonObject()) {
                JsonObject obj = rootElement.getAsJsonObject();
                if (obj.has("blocks")) {
                    Type listType = new TypeToken<List<SerializableOffsetBlock>>(){}.getType();
                    List serialized = (List)gson.fromJson(obj.get("blocks"), listType);
                    blocks.addAll(serialized.stream().map(SerializableOffsetBlock::toOffsetBlock).toList());
                }
                ServerLevel world = source.m_81372_();
                FurnaceMultiblockRegistry.selectMultiblock((Level)world, name, blocks);
                if (obj.has("valve")) {
                    JsonObject valveJson = obj.getAsJsonObject("valve");
                    OffsetBlock valve = new OffsetBlock(valveJson.get("x").getAsInt(), valveJson.get("y").getAsInt(), valveJson.get("z").getAsInt(), (Predicate<Block>)null, null);
                    FurnaceMultiblockRegistry.setValve((Level)world, valve);
                    FurnaceControllerBlockEntity.setValveOffset(valve);
                }
            } else if (rootElement.isJsonArray()) {
                Type listType = new TypeToken<List<SerializableOffsetBlock>>(){}.getType();
                List serialized = (List)gson.fromJson(rootElement, listType);
                blocks.addAll(serialized.stream().map(SerializableOffsetBlock::toOffsetBlock).toList());
            }
            source.m_288197_(() -> Component.m_237113_((String)("\u2705 Multiblock '" + name + "' loaded! (" + blocks.size() + " blocks)")), false);
            ServerLevel world = source.m_81372_();
            OffsetBlock valve = FurnaceMultiblockRegistry.getValve((Level)world);
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncMultiblockDataPacket(name, blocks.stream().map(SerializableOffsetBlock::fromOffsetBlock).toList(), valve != null ? SerializableOffsetBlock.fromOffsetBlock(valve) : null));
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Issue while loading: " + e.getMessage())));
            e.printStackTrace();
        }
        return 1;
    }
}

