/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.compat;

import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.gui.GuiGraphics;

public class HeatBarDrawable
implements IDrawable {
    private final int width;
    private final int height;
    private final int heatValue;
    private final int maxHeat;

    public HeatBarDrawable(int width, int height, int heatValue, int maxHeat) {
        this.width = width;
        this.height = height;
        this.heatValue = heatValue;
        this.maxHeat = maxHeat;
    }

    public void draw(GuiGraphics gui, int x, int y) {
        int[] heatMarks;
        int colorTop = -2271915;
        int colorBottom = -11184675;
        gui.m_280024_(x, y, x + this.width, y + this.height, colorTop, colorBottom);
        float fraction = Math.min(1.0f, (float)this.heatValue / (float)this.maxHeat);
        int filledHeight = (int)((float)this.height * fraction);
        int hiddenHeight = this.height - filledHeight;
        if (hiddenHeight > 0) {
            int overlayColor = -12303292;
            gui.m_280509_(x, y, x + this.width, y + hiddenHeight, overlayColor);
        }
        int borderColor = -16777216;
        this.drawBorder(gui, x, y, this.width, this.height, 1, borderColor);
        for (int mark : heatMarks = new int[]{500, 1000, 1500}) {
            float markFraction = Math.min(1.0f, (float)mark / (float)this.maxHeat);
            int markY = y + this.height - (int)(markFraction * (float)this.height);
            gui.m_280509_(x - 2, markY, x + 2, markY + 1, -16777216);
        }
    }

    private void drawBorder(GuiGraphics gui, int x, int y, int width, int height, int thickness, int color) {
        gui.m_280509_(x - thickness, y - thickness, x + width + thickness, y, color);
        gui.m_280509_(x - thickness, y + height, x + width + thickness, y + height + thickness, color);
        gui.m_280509_(x - thickness, y, x, y + height, color);
        gui.m_280509_(x + width, y, x + width + thickness, y + height, color);
        gui.m_280509_(x - thickness, y - thickness, x + thickness, y + thickness, color);
        gui.m_280509_(x + width - thickness, y - thickness, x + width + thickness, y + thickness, color);
        gui.m_280509_(x - thickness, y + height - thickness, x + thickness, y + height + thickness, color);
        gui.m_280509_(x + width, y + height - thickness, x + width + thickness, y + height + thickness, color);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

