/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class RealisticFurnaceConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CUSTOM_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> STRUCTURE_BLOCKS_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> STRUCTURE_BLOCKS_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> VALID_TAGS;
    public static final ForgeConfigSpec.IntValue MAX_SCAN_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<String> FALLBACK_MULTIBLOCK_FILE;

    static {
        BUILDER.push("Fuel");
        CUSTOM_FUELS = BUILDER.comment("Custom fuels in format:\n\"<item_or_tag>,<burnTime>,<heatStrength>[,<maxHeat>]\"\nburnTime determines the time (in ticks) how long an item burns\nheatStrength is a value that determines the heat raise speed and max heat\nmaxHeat can be optionally set to hard force a max heat. Put it with caution, if not somewhat in sync with the dynamically created max heat based on heatStrength, it could lead to unrealistic heat jumps\nExample:\n\"minecraft:coal,1600,0.9\",\n\"minecraft:charcoal,1600,0.275,1350\",\n\"#minecraft:planks,300,0.2,800\"  (Tags begin with '#')\n\"minecraft:stick,150,0.1,800\"").defineList("fuels", List.of("minecraft:coal,1600,0.9", "minecraft:charcoal,1600,0.275,1350", "#minecraft:planks,300,0.1,800", "minecraft:stick,150,0.1,800"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Multiblock");
        BUILDER.comment("Here you can whitelist or blacklist blocks to ensure the scan of your custom structure works properly. You can only use either the tags + whitelist or the blacklist. Putting anything in the blacklist will disable the whitelist and tags");
        BUILDER.push("Whitelist");
        VALID_TAGS = BUILDER.comment("List of tags that upon scan are considered part of the multiblock if connected with the controller or each other").defineList("WhitelistedTags", List.of("minecraft:trapdoors"), obj -> obj instanceof String);
        STRUCTURE_BLOCKS_WHITELIST = BUILDER.comment("List of blocks that upon scan are considered part of the multiblock if connected with the controller or each other").defineList("whitelistedBlocks", List.of("minecraft:bricks", "minecraft:brick_stairs", "minecraft:brick_slab", "minecraft:brick_wall", "minecraft:campfire"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Blacklist");
        STRUCTURE_BLOCKS_BLACKLIST = BUILDER.comment("List of blocks that upon scan are not considered part of the multiblock\nBe careful with this setting. If not operated with caution, unexpected blocks may be scanned\nNote: If using the blacklist, you probably don't want to consider 'minecraft:air' blocks").defineList("blacklistedBlocks", List.of(""), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Settings");
        MAX_SCAN_BLOCKS = BUILDER.comment("Max amount of blocks that are considered when scanning the multiblock. This is to prevent an almost endless scan when the filter above are not set up properly").defineInRange("maxScanBlocks", 250, 1, Integer.MAX_VALUE);
        FALLBACK_MULTIBLOCK_FILE = BUILDER.comment("Default/Fallback multiblock file. Only reconfigure this if you are sure the multiblock you are going to put as fallback is valid\nThis is required if you want others to use by default a custom multiblock when downloading your modpack").define("TheFallbackFile", (Object)"original_furnace.json");
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

