/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.events;

import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockSavedData;
import com.fireblaze.realistic_furnace.multiblock.MultiblockUtils;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.fireblaze.realistic_furnace.multiblock.SerializableOffsetBlock;
import com.fireblaze.realistic_furnace.networking.NetworkHandler;
import com.fireblaze.realistic_furnace.networking.packet.SyncMultiblockDataPacket;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventHandler {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = player2.m_284548_();
        String selectedName = FurnaceMultiblockRegistry.getSelectedMultiblockName((Level)level);
        if (selectedName == null || selectedName.isEmpty()) {
            return;
        }
        List<OffsetBlock> structure = FurnaceMultiblockRegistry.getSelectedMultiblock((Level)level, selectedName);
        if (structure.isEmpty()) {
            return;
        }
        OffsetBlock valve = FurnaceMultiblockRegistry.getValve((Level)level);
        if (valve == null) {
            return;
        }
        List<SerializableOffsetBlock> serializable = structure.stream().map(SerializableOffsetBlock::fromOffsetBlock).toList();
        SyncMultiblockDataPacket packet = new SyncMultiblockDataPacket(selectedName, serializable, SerializableOffsetBlock.fromOffsetBlock(valve));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)packet);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerLevel level : server.m_129785_()) {
            FurnaceMultiblockSavedData data = FurnaceMultiblockSavedData.get(level);
            String selected = data.getSelected(level);
            if (selected.isEmpty()) continue;
            List<OffsetBlock> blocks = FurnaceMultiblockRegistry.loadByName((Level)level, selected);
            FurnaceMultiblockRegistry.selectMultiblock((Level)level, selected, blocks);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (!level.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        FurnaceMultiblockSavedData data = FurnaceMultiblockSavedData.get(level);
        if (data.getSelected(level).isEmpty()) {
            List<OffsetBlock> defaultBlocks = FurnaceMultiblockRegistry.loadByName((Level)level, MultiblockUtils.getFallbackFile());
            FurnaceMultiblockRegistry.selectMultiblock((Level)level, MultiblockUtils.getFallbackFile(), defaultBlocks);
        }
    }
}

