/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.multiblock;

import com.fireblaze.realistic_furnace.blocks.FurnaceControllerBlock;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRenderer;
import com.fireblaze.realistic_furnace.multiblock.MultiblockUtils;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FurnaceMultiblock {
    public static List<OffsetBlock> getCurrentStructure(Level world) {
        String selectedName = FurnaceMultiblockRegistry.getSelectedMultiblockName(world);
        List<OffsetBlock> structure = FurnaceMultiblockRegistry.getSelectedMultiblock(world, selectedName);
        if (structure.isEmpty()) {
            List<OffsetBlock> fallback = FurnaceMultiblockRegistry.loadByName(world, MultiblockUtils.getFallbackFile());
            FurnaceMultiblockRegistry.selectMultiblock(world, MultiblockUtils.getFallbackFile(), fallback);
            return fallback;
        }
        return structure;
    }

    public static boolean validateStructure(Level world, BlockPos origin) {
        BlockState controllerState = world.m_8055_(origin);
        Direction facing = Direction.NORTH;
        if (controllerState.m_60734_() instanceof FurnaceControllerBlock) {
            facing = (Direction)controllerState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        List<OffsetBlock> structure = FurnaceMultiblock.getCurrentStructure(world);
        for (OffsetBlock offset : structure) {
            BlockPos rotatedPos = FurnaceMultiblockRenderer.rotateOffset(offset, origin, facing);
            Block block = world.m_8055_(rotatedPos).m_60734_();
            if (offset.matcher().test(block)) continue;
            return false;
        }
        return true;
    }
}

