/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.multiblock;

import com.fireblaze.realistic_furnace.blocks.FurnaceControllerBlock;
import com.fireblaze.realistic_furnace.multiblock.MultiblockUtils;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class MultiblockScanner {
    private static final Set<Block> VALID_BRICK_BLOCKS = Set.of(Blocks.f_50076_, Blocks.f_50193_, Blocks.f_50410_, Blocks.f_50604_, Blocks.f_50683_);
    public static List<OffsetBlock> LAST_SCAN = new ArrayList<OffsetBlock>();

    private static boolean isValidBrickBlock(Block block) {
        Set<Block> blacklistedBlocks = MultiblockUtils.getBlacklistedBlocks();
        Set<Block> whitelistedBlocks = MultiblockUtils.getWhitelistedBlocks();
        Set<TagKey<Block>> validTags = MultiblockUtils.getValidTags();
        if (!blacklistedBlocks.isEmpty() && blacklistedBlocks.stream().anyMatch(Objects::nonNull)) {
            return !blacklistedBlocks.contains(block);
        }
        if (whitelistedBlocks.contains(block)) {
            return true;
        }
        for (TagKey<Block> tag : validTags) {
            if (!block.m_49966_().m_204336_(tag)) continue;
            return true;
        }
        return false;
    }

    public static List<OffsetBlock> scanFromController(CommandSourceStack source, Level level, BlockPos controllerPos) {
        LAST_SCAN.clear();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayList<OffsetBlock> foundBlocks = new ArrayList<OffsetBlock>();
        BlockState controllerState = level.m_8055_(controllerPos);
        Direction controllerFacing = controllerState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) ? (Direction)controllerState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) : Direction.NORTH;
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(controllerPos);
        int SCAN_LIMIT = MultiblockUtils.getMaxScanBlocks();
        while (!queue.isEmpty()) {
            if (foundBlocks.size() >= SCAN_LIMIT) {
                source.m_81352_((Component)Component.m_237113_((String)"Scan limit reached. Did you configure the block white/black list properly?"));
                break;
            }
            BlockPos current = (BlockPos)queue.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState state = level.m_8055_(current);
            Block block = state.m_60734_();
            if (!MultiblockScanner.isValidBrickBlock(block) && !(block instanceof FurnaceControllerBlock)) continue;
            BlockPos relative = current.m_121996_((Vec3i)controllerPos);
            BlockPos rotated = MultiblockScanner.rotateOffsetToSouth(relative, controllerFacing);
            BlockState savedState = state;
            if (block instanceof StairBlock) {
                Direction stairFacing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
                Direction relativeFacing = MultiblockScanner.rotateDirectionRelativeToController(stairFacing, controllerFacing);
                savedState = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)StairBlock.f_56841_, (Comparable)relativeFacing)).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)state.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)state.m_61143_((Property)StairBlock.f_56843_)));
            }
            foundBlocks.add(new OffsetBlock(rotated.m_123341_(), rotated.m_123342_(), rotated.m_123343_(), List.of(block), savedState));
            for (Direction dir : Direction.values()) {
                BlockState neighborState;
                Block neighborBlock;
                BlockPos neighbor = current.m_121945_(dir);
                if (visited.contains(neighbor) || !MultiblockScanner.isValidBrickBlock(neighborBlock = (neighborState = level.m_8055_(neighbor)).m_60734_())) continue;
                queue.add(neighbor);
            }
        }
        foundBlocks.sort(Comparator.comparingInt(OffsetBlock::y).thenComparingInt(OffsetBlock::x).thenComparingInt(OffsetBlock::z));
        LAST_SCAN.addAll(foundBlocks);
        return foundBlocks;
    }

    private static Direction rotateDirectionRelativeToController(Direction original, Direction controllerFacing) {
        int originalIndex = original.m_122416_();
        int controllerIndex = controllerFacing.m_122416_();
        int relativeIndex = (originalIndex - controllerIndex + 4) % 4;
        return Direction.m_122407_((int)relativeIndex);
    }

    private static BlockPos rotateOffsetToSouth(BlockPos offset, Direction facing) {
        int x = offset.m_123341_();
        int y = offset.m_123342_();
        int z = offset.m_123343_();
        return switch (facing) {
            case Direction.SOUTH -> new BlockPos(-x, y, -z);
            case Direction.NORTH -> new BlockPos(x, y, z);
            case Direction.EAST -> new BlockPos(z, y, -x);
            case Direction.WEST -> new BlockPos(-z, y, x);
            default -> new BlockPos(x, y, z);
        };
    }
}

