/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.multiblock;

import com.fireblaze.realistic_furnace.config.RealisticFurnaceConfig;
import com.fireblaze.realistic_furnace.fuel.FurnaceFuelRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class MultiblockUtils {
    public static Set<Block> getWhitelistedBlocks() {
        return ((List)RealisticFurnaceConfig.STRUCTURE_BLOCKS_WHITELIST.get()).stream().map(s -> {
            String[] parts = s.split(":", 2);
            if (parts.length != 2) {
                System.err.println("[ERROR] Ung\u00fcltiger Block/Tag in der Config Whitelist: " + s);
                return null;
            }
            return (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]));
        }).collect(Collectors.toSet());
    }

    public static Set<Block> getBlacklistedBlocks() {
        return ((List)RealisticFurnaceConfig.STRUCTURE_BLOCKS_BLACKLIST.get()).stream().map(String::trim).filter(s -> !s.isEmpty()).map(s -> {
            String[] parts = s.split(":", 2);
            if (parts.length != 2) {
                System.err.println("[ERROR] Ung\u00fcltiger Block/Tag in der Config Blacklist: " + s);
                return null;
            }
            return (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]));
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<TagKey<Block>> getValidTags() {
        return ((List)RealisticFurnaceConfig.VALID_TAGS.get()).stream().map(s -> {
            String[] parts = s.split(":", 2);
            if (parts.length != 2) {
                System.err.println("[ERROR] Ung\u00fcltiger Block/Tag in der Config: " + s);
                return null;
            }
            return TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_256975_.m_123023_(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]));
        }).collect(Collectors.toSet());
    }

    public static void loadCustomFuels() {
        List list = (List)RealisticFurnaceConfig.CUSTOM_FUELS.get();
        if (list == null) {
            return;
        }
        for (String raw : list) {
            String entry;
            if (raw == null || (entry = raw.trim()).isEmpty()) continue;
            try {
                String maxPart;
                String[] parts = entry.split(",");
                if (parts.length < 3) {
                    System.err.println("[Realistic Furnace] Invalid fuel entry (too few parts): " + entry);
                    continue;
                }
                String idPart = parts[0].trim();
                int burnTime = Integer.parseInt(parts[1].trim());
                float heatStrength = Float.parseFloat(parts[2].trim());
                Integer maxHeat = null;
                if (parts.length >= 4 && !(maxPart = parts[3].trim()).isEmpty()) {
                    maxHeat = Integer.parseInt(maxPart);
                }
                if (idPart.startsWith("#")) {
                    String tagId = idPart.substring(1);
                    String[] tagSplit = tagId.split(":", 2);
                    if (tagSplit.length != 2) {
                        System.err.println("[Realistic Furnace] Invalid tag id: " + tagId);
                        continue;
                    }
                    ResourceLocation tagRL = ResourceLocation.fromNamespaceAndPath((String)tagSplit[0], (String)tagSplit[1]);
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagRL);
                    if (maxHeat != null) {
                        FurnaceFuelRegistry.register((TagKey<Item>)tag, burnTime, heatStrength, (int)maxHeat);
                    } else {
                        FurnaceFuelRegistry.register((TagKey<Item>)tag, burnTime, heatStrength);
                    }
                    System.out.printf("[Realistic Furnace] Registered fuel tag %s -> burn=%d, heat=%f, max=%s%n", tagId, burnTime, Float.valueOf(heatStrength), maxHeat == null ? "none" : maxHeat);
                    continue;
                }
                String[] idSplit = idPart.split(":", 2);
                if (idSplit.length != 2) {
                    System.err.println("[Realistic Furnace] Invalid resource id: " + idPart);
                    continue;
                }
                ResourceLocation itemRL = ResourceLocation.fromNamespaceAndPath((String)idSplit[0], (String)idSplit[1]);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemRL);
                if (item == null || item == Items.f_41852_) {
                    System.err.println("[Realistic Furnace] Could not find item for fuel entry: " + idPart);
                    continue;
                }
                if (maxHeat != null) {
                    FurnaceFuelRegistry.register(item, burnTime, heatStrength, (int)maxHeat);
                } else {
                    FurnaceFuelRegistry.register(item, burnTime, heatStrength);
                }
                System.out.printf("[Realistic Furnace] Registered fuel %s -> burn=%d, heat=%f, max=%s%n", idPart, burnTime, Float.valueOf(heatStrength), maxHeat == null ? "none" : maxHeat);
            }
            catch (Exception e) {
                System.err.println("[Realistic Furnace] Fehler beim Parsen von fuel-entry: " + entry);
                e.printStackTrace();
            }
        }
    }

    public static int getMaxScanBlocks() {
        return (Integer)RealisticFurnaceConfig.MAX_SCAN_BLOCKS.get();
    }

    public static String getFallbackFile() {
        return (String)RealisticFurnaceConfig.FALLBACK_MULTIBLOCK_FILE.get();
    }
}

