/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.multiblock;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class OffsetBlock {
    private final int x;
    private final int y;
    private final int z;
    private final Predicate<Block> matcher;
    private final BlockState stateTemplate;

    public OffsetBlock(int x, int y, int z, Predicate<Block> matcher, BlockState stateTemplate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.matcher = matcher;
        this.stateTemplate = stateTemplate;
    }

    public OffsetBlock(int x, int y, int z, List<Block> allowedBlocks, BlockState stateTemplate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.matcher = allowedBlocks::contains;
        this.stateTemplate = stateTemplate;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Predicate<Block> matcher() {
        return this.matcher;
    }

    public BlockState getStateTemplate() {
        return this.stateTemplate;
    }

    public String describeState() {
        if (this.stateTemplate == null) {
            return "";
        }
        if (this.stateTemplate.m_60734_() instanceof WallBlock || this.stateTemplate.m_60734_() instanceof FenceBlock) {
            return "";
        }
        Map<String, String> props = this.stateTemplate.m_61148_().entrySet().stream().collect(Collectors.toMap(e -> ((Property)e.getKey()).m_61708_(), e -> ((Comparable)e.getValue()).toString()));
        return props.isEmpty() ? "" : props.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", ", " [", "]"));
    }

    public String describeDebug() {
        String name = this.getBlockName();
        String props = this.describeState();
        return String.format("Offset(%d,%d,%d) -> Block=%s%s", this.x, this.y, this.z, name, props.isEmpty() ? "" : props);
    }

    public String getBlockName() {
        return this.stateTemplate.m_60734_().m_49954_().getString();
    }
}

