/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.multiblock;

import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SerializableOffsetBlock {
    @SerializedName(value="x")
    public int x;
    @SerializedName(value="y")
    public int y;
    @SerializedName(value="z")
    public int z;
    @SerializedName(value="block")
    public String blockId;
    @SerializedName(value="properties")
    public Map<String, String> blockStateProperties = new HashMap<String, String>();

    public SerializableOffsetBlock(OffsetBlock offset) {
        this.x = offset.x();
        this.y = offset.y();
        this.z = offset.z();
        BlockState state = offset.getStateTemplate();
        if (state != null) {
            this.blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString();
            state.m_61148_().forEach((prop, val) -> this.blockStateProperties.put(prop.m_61708_(), val.toString()));
        }
    }

    public OffsetBlock toOffsetBlock() {
        String[] parts = this.blockId.split(":", 2);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)(parts.length > 1 ? parts[1] : ""));
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(id);
        if (block == null) {
            System.err.println("\u26a0 Unbekannter Block: " + this.blockId + " \u2013 Fallback zu AIR");
            return new OffsetBlock(this.x, this.y, this.z, List.of(Blocks.f_50016_), Blocks.f_50016_.m_49966_());
        }
        BlockState state = block.m_49966_();
        for (Map.Entry<String, String> entry : this.blockStateProperties.entrySet()) {
            Property property = state.m_60734_().m_49965_().m_61081_(entry.getKey());
            if (property == null) continue;
            state = SerializableOffsetBlock.applyProperty(state, property, entry.getValue());
        }
        return new OffsetBlock(this.x, this.y, this.z, List.of(block), state);
    }

    private static <T extends Comparable<T>> BlockState applyProperty(BlockState state, Property<T> property, String valueName) {
        return property.m_6215_(valueName).map(val -> (BlockState)state.m_61124_(property, val)).orElse(state);
    }

    public SerializableOffsetBlock() {
    }

    public static SerializableOffsetBlock fromOffsetBlock(OffsetBlock offset) {
        return new SerializableOffsetBlock(offset);
    }
}

