/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.networking.packet;

import com.fireblaze.realistic_furnace.client.ClientPacketHandler;
import com.fireblaze.realistic_furnace.multiblock.FurnaceMultiblockRegistry;
import com.fireblaze.realistic_furnace.multiblock.OffsetBlock;
import com.fireblaze.realistic_furnace.multiblock.SerializableOffsetBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class SyncMultiblockDataPacket {
    public final String name;
    public final List<SerializableOffsetBlock> blocks;
    public final SerializableOffsetBlock valve;

    public SyncMultiblockDataPacket(String name, List<SerializableOffsetBlock> blocks, SerializableOffsetBlock valve) {
        this.name = name;
        this.blocks = blocks;
        this.valve = valve;
    }

    public static void encode(SyncMultiblockDataPacket msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.name);
        buf.writeInt(msg.blocks.size());
        for (SerializableOffsetBlock b : msg.blocks) {
            buf.writeInt(b.x);
            buf.writeInt(b.y);
            buf.writeInt(b.z);
            buf.m_130070_(b.blockId != null ? b.blockId : "minecraft:air");
            buf.writeInt(b.blockStateProperties.size());
            for (Map.Entry<String, String> entry : b.blockStateProperties.entrySet()) {
                buf.m_130070_(entry.getKey());
                buf.m_130070_(entry.getValue());
            }
        }
        boolean hasValve = msg.valve != null;
        buf.writeBoolean(hasValve);
        if (hasValve) {
            buf.writeInt(msg.valve.x);
            buf.writeInt(msg.valve.y);
            buf.writeInt(msg.valve.z);
            buf.m_130070_(msg.valve.blockId != null ? msg.valve.blockId : "minecraft:air");
            buf.writeInt(msg.valve.blockStateProperties.size());
            for (Map.Entry<String, String> entry : msg.valve.blockStateProperties.entrySet()) {
                buf.m_130070_(entry.getKey());
                buf.m_130070_(entry.getValue());
            }
        }
    }

    public static SyncMultiblockDataPacket decode(FriendlyByteBuf buf) {
        String value;
        String key;
        int z;
        int y;
        int x;
        String name = buf.m_130277_();
        int size = buf.readInt();
        ArrayList<SerializableOffsetBlock> blocks = new ArrayList<SerializableOffsetBlock>();
        for (int i = 0; i < size; ++i) {
            x = buf.readInt();
            y = buf.readInt();
            z = buf.readInt();
            String blockId = buf.m_130277_();
            int propCount = buf.readInt();
            HashMap<String, String> props = new HashMap<String, String>();
            for (int j = 0; j < propCount; ++j) {
                key = buf.m_130277_();
                value = buf.m_130277_();
                props.put(key, value);
            }
            SerializableOffsetBlock block = new SerializableOffsetBlock();
            block.x = x;
            block.y = y;
            block.z = z;
            block.blockId = blockId;
            block.blockStateProperties = props;
            blocks.add(block);
        }
        SerializableOffsetBlock valve = null;
        if (buf.readBoolean()) {
            x = buf.readInt();
            y = buf.readInt();
            z = buf.readInt();
            String valveId = buf.m_130277_();
            int valvePropCount = buf.readInt();
            HashMap<String, String> valveProps = new HashMap<String, String>();
            for (int j = 0; j < valvePropCount; ++j) {
                key = buf.m_130277_();
                value = buf.m_130277_();
                valveProps.put(key, value);
            }
            valve = new SerializableOffsetBlock();
            valve.x = x;
            valve.y = y;
            valve.z = z;
            valve.blockId = valveId;
            valve.blockStateProperties = valveProps;
        }
        return new SyncMultiblockDataPacket(name, blocks, valve);
    }

    public static void handle(SyncMultiblockDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Level world = Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()).m_9236_();
                List<OffsetBlock> blocks = msg.blocks.stream().map(SerializableOffsetBlock::toOffsetBlock).toList();
                FurnaceMultiblockRegistry.selectMultiblock(world, msg.name, blocks);
                if (msg.valve != null) {
                    FurnaceMultiblockRegistry.setValve(world, msg.valve.toOffsetBlock());
                }
            }
            if (FMLEnvironment.dist.isClient()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleMultiblockData(msg));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

