/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.realistic_furnace.screens;

import com.fireblaze.realistic_furnace.blockentities.FurnaceControllerBlockEntity;
import com.fireblaze.realistic_furnace.containers.FurnaceContainer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class FurnaceScreen
extends AbstractContainerScreen<FurnaceContainer> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"realistic_furnace", (String)"textures/gui/realistic_furnace_gui.png");

    public FurnaceScreen(FurnaceContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        int i;
        RenderSystem.setShader(GameRenderer::m_172817_);
        gui.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int HEAT_BAR_WIDTH = 8;
        int HEAT_BAR_HEIGHT = 64;
        int HEAT_BAR_X = 72;
        int HEAT_BAR_Y = 40;
        int centerX = this.f_97735_ + this.f_97726_ / 2;
        int centerY = this.f_97736_ + this.f_97727_ / 2;
        int x = centerX + 72 - 4;
        int y = centerY - 40 - 32;
        float currentHeat = ((FurnaceContainer)this.f_97732_).getHeatData().m_6413_(0);
        int maxHeat = ((FurnaceContainer)this.f_97732_).getBlockEntity().getMaxHeat();
        int heatHeight = (int)(currentHeat / (float)maxHeat * 64.0f);
        int colorTop = -2271915;
        int colorBottom = -11184675;
        gui.m_280024_(x, y, x + 8, y + 64, colorTop, colorBottom);
        int hiddenHeight = 64 - heatHeight;
        if (hiddenHeight > 0) {
            int overlayColor = -12303292;
            gui.m_280509_(x, y, x + 8, y + hiddenHeight, overlayColor);
        }
        this.drawBorder(gui, x, y, 8, 64, 1, -16777216);
        int[] heatMarks = new int[]{500, 1000, 1500};
        String[] heatLabels = new String[]{"500 ", "1000", "1500"};
        int scaleOffset = 2;
        int scaleLength = 4;
        int textColor = -16777216;
        float textScale = 0.7f;
        for (i = 0; i < heatMarks.length; ++i) {
            int mark = heatMarks[i];
            float fraction = Math.min(1.0f, (float)mark / (float)((FurnaceContainer)this.f_97732_).getHeatData().m_6413_(1));
            int markY = y + 64 - (int)(fraction * 64.0f);
            gui.m_280509_(x - 2, markY, x - 2 + 4, markY + 1, -16777216);
            gui.m_280168_().m_85836_();
            gui.m_280168_().m_85841_(textScale, textScale, 1.0f);
            int textWidth = this.f_96547_.m_92895_(heatLabels[i]);
            String string = heatLabels[i];
            int n = (int)((float)(x - 2 - textWidth + 6) / textScale);
            Objects.requireNonNull(this.f_96547_);
            gui.m_280056_(this.f_96547_, string, n, (int)((float)(markY - 9 / 2 + 2) / textScale), -16777216, false);
            gui.m_280168_().m_85849_();
        }
        for (i = 0; i < ((FurnaceContainer)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = ((FurnaceContainer)this.f_97732_).m_38853_(i);
            if (i > 8) break;
            int current = ((FurnaceContainer)this.f_97732_).getProgressData().m_6413_(i * 2) / 10;
            int stalledInt = ((FurnaceContainer)this.f_97732_).getProgressData().m_6413_(i * 2 + 1);
            boolean isStalled = stalledInt != 0;
            int max = ((FurnaceContainer)this.f_97732_).getBlockEntity().getMaxProgress();
            if (max <= 0) continue;
            int barWidth = 18;
            int barHeight = 1;
            int scaledSlot = (int)Math.ceil((double)current * (double)barWidth / (double)max);
            int xSlot = this.f_97735_ + slot.f_40220_ + (16 - barWidth) / 2;
            int ySlot = this.f_97736_ + slot.f_40221_ - barHeight - 2;
            int colorLeft = isStalled ? -43691 : -7811841;
            int colorRight = isStalled ? -5618620 : -16759638;
            gui.m_280024_(xSlot, ySlot, xSlot + scaledSlot, ySlot + barHeight, colorLeft, colorRight);
        }
        int fuelSlotX = this.f_97735_ + 15;
        int fuelSlotY = this.f_97736_ + 34 - 17;
        int FLAME_WIDTH = 14;
        int FLAME_HEIGHT = 14;
        int burnTime = ((FurnaceContainer)this.f_97732_).getBurnTimeData().m_6413_(0);
        int burnTimeTotal = ((FurnaceContainer)this.f_97732_).getBurnTimeData().m_6413_(1);
        if (burnTime > 0 && burnTimeTotal > 0) {
            int flameHeight = (int)Math.ceil((float)burnTime * (float)FLAME_HEIGHT / (float)burnTimeTotal);
            gui.m_280218_(TEXTURE, fuelSlotX, fuelSlotY + (FLAME_HEIGHT - flameHeight), 176, FLAME_HEIGHT - flameHeight, FLAME_WIDTH, flameHeight);
        }
    }

    private void drawBorder(GuiGraphics gui, int x, int y, int width, int height, int thickness, int color) {
        gui.m_280509_(x - thickness, y - thickness, x + width + thickness, y, color);
        gui.m_280509_(x - thickness, y + height, x + width + thickness, y + height + thickness, color);
        gui.m_280509_(x - thickness, y, x, y + height, color);
        gui.m_280509_(x + width, y, x + width + thickness, y + height, color);
        gui.m_280509_(x - thickness, y - thickness, x + thickness, y + thickness, color);
        gui.m_280509_(x + width - thickness, y - thickness, x + width + thickness, y + thickness, color);
        gui.m_280509_(x - thickness, y + height - thickness, x + thickness, y + height + thickness, color);
        gui.m_280509_(x + width - thickness, y + height - thickness, x + width + thickness, y + height + thickness, color);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        int HEAT_BAR_WIDTH = 8;
        int HEAT_BAR_HEIGHT = 64;
        int HEAT_BAR_X = 72;
        int HEAT_BAR_Y = 40;
        int centerX = this.f_97735_ + this.f_97726_ / 2;
        int centerY = this.f_97736_ + this.f_97727_ / 2;
        int x = centerX + 72 - 4;
        int y = centerY - 40 - 32;
        if (mouseX >= x && mouseX < x + 8 && mouseY >= y && mouseY < y + 64) {
            int threateningHeat;
            float currentHeat = ((FurnaceContainer)this.f_97732_).getHeatData().m_6413_(0);
            TextColor color = currentHeat >= (float)(threateningHeat = FurnaceControllerBlockEntity.getThreateningHeat()) ? TextColor.m_131266_((int)0xFF5555) : (currentHeat >= 1600.0f ? TextColor.m_131266_((int)0xFFFF55) : TextColor.m_131266_((int)0xFFFFFF));
            gui.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)((int)currentHeat + "\u00b0C")).m_130948_(Style.f_131099_.m_131148_(color)), mouseX, mouseY);
        }
        this.m_280072_(gui, mouseX, mouseY);
    }
}

