/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.whales.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.DolphinJumpGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jufyer.plugin.whales.Main;

public class Whale
extends Dolphin {
    public static final NamespacedKey KEY = new NamespacedKey((Plugin)Main.getInstance(), "Whale");

    public Whale(Location loc) {
        super(EntityType.DOLPHIN, (Level)((CraftWorld)loc.getWorld()).getHandle());
        this.setPosRaw(loc.getX(), loc.getY(), loc.getZ());
        this.getBukkitEntity().getPersistentDataContainer().set(KEY, PersistentDataType.BOOLEAN, (Object)true);
        this.setInvulnerable(true);
        this.setCustomName(Component.nullToEmpty((String)"with"));
        this.setCustomNameVisible(false);
        this.persist = true;
        ((CraftWorld)loc.getWorld()).getHandle().addFreshEntity((Entity)this, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public void setTreasurePos(BlockPos treasurePos) {
    }

    public BlockPos getTreasurePos() {
        return null;
    }

    public boolean gotFish() {
        return true;
    }

    public void setGotFish(boolean hasFish) {
    }

    public int getMoistnessLevel() {
        return 0;
    }

    public void setMoisntessLevel(int moistness) {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new DolphinJumpGoal((Dolphin)this, 10));
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.goalSelector.addGoal(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.goalSelector.addGoal(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guardian.class, 8.0f, 1.0, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Guardian.class}).setAlertOthers(new Class[0]));
    }

    public int getMaxAirSupply() {
        return this.maxAirTicks;
    }

    protected int increaseAirSupply(int air) {
        return this.getMaxAirSupply();
    }

    public void tick() {
        super.tick();
        if (!this.isInWaterRainOrBubble()) {
            this.setMoisntessLevel(this.getMoistnessLevel() - 1);
            if (this.getMoistnessLevel() <= 0) {
                this.hurt(this.damageSources().dryOut(), 1.0f);
            }
        }
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
        if (this.level().isClientSide && this.isInWater() && this.getDeltaMovement().lengthSqr() > 0.03) {
            Vec3 vec3d = this.getViewVector(0.0f);
            float f = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.3f;
            float f1 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 0.3f;
            float f2 = 1.2f - this.random.nextFloat() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vec3d.x * (double)f2 + (double)f, this.getY() - vec3d.y, this.getZ() - vec3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vec3d.x * (double)f2 - (double)f, this.getY() - vec3d.y, this.getZ() - vec3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canBeLeashed() {
        return false;
    }
}

