/*
 * Decompiled with CFR 0.152.
 */
package org.jufyer.plugin.whales.listeners;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class customBlockListeners
implements Listener {
    private final Map<Player, Long> lastPlacedBlockTimes = new HashMap<Player, Long>();
    private static final long COOLDOWN_TIME = 250L;

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        ItemMeta meta;
        ArmorStand as;
        if (event.getRightClicked().getType().equals((Object)EntityType.ARMOR_STAND) && (as = (ArmorStand)event.getRightClicked()).getEquipment().getHelmet() != null && as.getEquipment().getHelmet().getType() == Material.NAUTILUS_SHELL && (meta = as.getEquipment().getHelmet().getItemMeta()) != null && meta.getCustomModelData() == 1234) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemMeta meta;
        ItemStack item = event.getItem();
        if (item != null && item.hasItemMeta() && (meta = item.getItemMeta()) != null && meta.getCustomModelData() == 1234 && event.getAction().isRightClick()) {
            long lastPlacedTime;
            Player player = event.getPlayer();
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastPlacedTime = this.lastPlacedBlockTimes.getOrDefault(player, 0L).longValue()) >= 250L) {
                if (event.getClickedBlock() != null && event.getClickedBlock().getType() != Material.AIR && !event.getClickedBlock().isLiquid()) {
                    Location loc;
                    if (event.getBlockFace().equals((Object)BlockFace.UP)) {
                        loc = event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0);
                        this.createBlock(loc);
                        this.lastPlacedBlockTimes.put(player, currentTime);
                        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                            event.getItem().setAmount(event.getItem().getAmount() - 1);
                        }
                    } else if (event.getBlockFace().equals((Object)BlockFace.DOWN)) {
                        loc = event.getClickedBlock().getLocation().add(0.0, -1.0, 0.0);
                        this.createBlock(loc);
                        this.lastPlacedBlockTimes.put(player, currentTime);
                        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                            event.getItem().setAmount(event.getItem().getAmount() - 1);
                        }
                    } else if (event.getBlockFace().equals((Object)BlockFace.WEST)) {
                        loc = event.getClickedBlock().getLocation().add(-1.0, 0.0, 0.0);
                        this.createBlock(loc);
                        this.lastPlacedBlockTimes.put(player, currentTime);
                        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                            event.getItem().setAmount(event.getItem().getAmount() - 1);
                        }
                    } else if (event.getBlockFace().equals((Object)BlockFace.EAST)) {
                        loc = event.getClickedBlock().getLocation().add(1.0, 0.0, 0.0);
                        this.createBlock(loc);
                        this.lastPlacedBlockTimes.put(player, currentTime);
                        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                            event.getItem().setAmount(event.getItem().getAmount() - 1);
                        }
                    }
                    if (event.getBlockFace().equals((Object)BlockFace.NORTH)) {
                        loc = event.getClickedBlock().getLocation().add(0.0, 0.0, -1.0);
                        this.createBlock(loc);
                        this.lastPlacedBlockTimes.put(player, currentTime);
                        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                            event.getItem().setAmount(event.getItem().getAmount() - 1);
                        }
                    } else if (event.getBlockFace().equals((Object)BlockFace.SOUTH)) {
                        loc = event.getClickedBlock().getLocation().add(0.0, 0.0, 1.0);
                        this.createBlock(loc);
                        this.lastPlacedBlockTimes.put(player, currentTime);
                        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                            event.getItem().setAmount(event.getItem().getAmount() - 1);
                        }
                    }
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    private void createBlock(Location loc) {
        ItemStack Barnacles = new ItemStack(Material.NAUTILUS_SHELL);
        ItemMeta meta = Barnacles.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7rBarnacle Spike");
            meta.setCustomModelData(Integer.valueOf(1234));
            Barnacles.setItemMeta(meta);
        }
        Location spawnLoc = loc.subtract(-0.5, 0.0, -0.5);
        ArmorStand as = (ArmorStand)loc.getWorld().spawn(spawnLoc, ArmorStand.class);
        as.setInvisible(true);
        as.setGravity(false);
        as.setBodyYaw(0.0f);
        as.setRotation(0.0f, 0.0f);
        as.setCanMove(false);
        as.setCustomNameVisible(false);
        as.setPersistent(true);
        as.getEquipment().setHelmet(Barnacles);
        loc.getBlock().setType(Material.QUARTZ_BLOCK);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().getType().equals((Object)Material.QUARTZ_BLOCK)) {
            Location blockLoc = event.getBlock().getLocation();
            for (ArmorStand as : blockLoc.getWorld().getEntitiesByClass(ArmorStand.class)) {
                if (as.getLocation().getBlockX() != blockLoc.getBlockX() || as.getLocation().getBlockY() != blockLoc.getBlockY() || as.getLocation().getBlockZ() != blockLoc.getBlockZ()) continue;
                as.remove();
                ItemStack Barnacles = new ItemStack(Material.NAUTILUS_SHELL);
                ItemMeta meta = Barnacles.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName("\u00a7rBarnacle Spike");
                    meta.setCustomModelData(Integer.valueOf(1234));
                    Barnacles.setItemMeta(meta);
                }
                as.getWorld().dropItemNaturally(as.getLocation(), Barnacles);
            }
        }
    }

    @EventHandler
    public void onBlockRedstone(BlockRedstoneEvent event) {
        BlockFace[] faces;
        Block block = event.getBlock();
        for (BlockFace face : faces = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST}) {
            ItemMeta meta;
            ItemStack Barnacles;
            Location blockLoc;
            Block adjacentBlock = block.getRelative(face);
            if (event.getNewCurrent() > 0 && adjacentBlock.getType() == Material.QUARTZ_BLOCK) {
                blockLoc = adjacentBlock.getLocation();
                for (ArmorStand as : blockLoc.getWorld().getEntitiesByClass(ArmorStand.class)) {
                    if (as.getLocation().getBlockX() != blockLoc.getBlockX() || as.getLocation().getBlockY() != blockLoc.getBlockY() || as.getLocation().getBlockZ() != blockLoc.getBlockZ()) continue;
                    as.getEquipment().getHelmet().setAmount(0);
                    Barnacles = new ItemStack(Material.NAUTILUS_SHELL);
                    meta = Barnacles.getItemMeta();
                    if (meta != null) {
                        meta.setDisplayName("\u00a7rBarnacle Spike Extended");
                        meta.setCustomModelData(Integer.valueOf(12345));
                        Barnacles.setItemMeta(meta);
                    }
                    as.setInvisible(true);
                    as.setGravity(false);
                    as.setBodyYaw(0.0f);
                    as.setRotation(0.0f, 0.0f);
                    as.setCanMove(false);
                    as.setCustomNameVisible(false);
                    as.setPersistent(true);
                    as.getEquipment().setHelmet(Barnacles);
                    for (Entity player : as.getNearbyEntities(0.0, 1.0, 0.0)) {
                        if (!(player instanceof Player)) continue;
                        Player p = (Player)player;
                        p.damage(5.0);
                    }
                }
            }
            if (event.getNewCurrent() != 0) continue;
            blockLoc = adjacentBlock.getLocation();
            for (ArmorStand as : blockLoc.getWorld().getEntitiesByClass(ArmorStand.class)) {
                if (as.getLocation().getBlockX() != blockLoc.getBlockX() || as.getLocation().getBlockY() != blockLoc.getBlockY() || as.getLocation().getBlockZ() != blockLoc.getBlockZ()) continue;
                as.getEquipment().getHelmet().setAmount(0);
                Barnacles = new ItemStack(Material.NAUTILUS_SHELL);
                meta = Barnacles.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName("\u00a7rBarnacle Spike");
                    meta.setCustomModelData(Integer.valueOf(1234));
                    Barnacles.setItemMeta(meta);
                }
                as.setInvisible(true);
                as.setGravity(false);
                as.setBodyYaw(0.0f);
                as.setRotation(0.0f, 0.0f);
                as.setCanMove(false);
                as.setCustomNameVisible(false);
                as.setPersistent(true);
                as.getEquipment().setHelmet(Barnacles);
            }
        }
    }
}

