/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.neospeedzero.NeoSpeedMessages;
import xland.mcmod.neospeedzero.api.NeoSpeedLifecycleEvents;
import xland.mcmod.neospeedzero.api.SpeedrunStartupConfig;
import xland.mcmod.neospeedzero.command.RecordReference;
import xland.mcmod.neospeedzero.itemext.ItemExtensions;
import xland.mcmod.neospeedzero.mixin.PlayerAdvancementsAccessor;
import xland.mcmod.neospeedzero.neoforge.NeoSpeedLifecycleImpl;
import xland.mcmod.neospeedzero.record.SpeedrunChallenge;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.record.manager.PlayerRole;
import xland.mcmod.neospeedzero.record.manager.RecordManager;
import xland.mcmod.neospeedzero.record.manager.SpeedrunRecordHolder;
import xland.mcmod.neospeedzero.resource.SpeedrunGoal;
import xland.mcmod.neospeedzero.util.ABSDebug;
import xland.mcmod.neospeedzero.view.ChallengeSnapshot;

public final class NeoSpeedLifecycle {
    private NeoSpeedLifecycle() {
    }

    public static Optional<Component> startSpeedrun(ServerPlayer player, SpeedrunStartupConfig startupConfig) {
        SpeedrunRecord record = player.ns0$currentRecord();
        if (record != null) {
            return Optional.of(Component.translatable((String)"message.neospeedzero.record.start.started", (Object[])new Object[]{player.getDisplayName(), record.snapshot()}));
        }
        EventResult eventResult = ((NeoSpeedLifecycleEvents.StartRecord)NeoSpeedLifecycleEvents.START_RECORD.invoker()).onStart(player, startupConfig);
        if (eventResult == EventResult.interruptFalse()) {
            return Optional.of(Component.translatable((String)"message.neospeedzero.record.start.cancel"));
        }
        record = startupConfig.createRecord(player.ns0$time());
        Component message = player.ns0$serverRecordManager().startHosting(record, player);
        if (message != null) {
            return Optional.of(message);
        }
        NeoSpeedMessages.announceRecordStart(player, record);
        NeoSpeedLifecycle.initSpeedrunBeginning(player, record);
        return Optional.empty();
    }

    private static void initSpeedrunBeginning(ServerPlayer player, SpeedrunRecord record) {
        record.difficulty().onStart(player, record);
        NeoSpeedLifecycle.checkExistingThings(player);
    }

    private static void checkExistingThings(ServerPlayer player) {
        player.getInventory().forEach(itemStack -> NeoSpeedLifecycle.onInventoryChange(player, itemStack));
        ((PlayerAdvancementsAccessor)player.getAdvancements()).ns0$progress().forEach((advancementHolder, advancementProgress) -> {
            if (!advancementProgress.isDone()) {
                return;
            }
            NeoSpeedLifecycle.onAdvancementMade(player, advancementHolder);
        });
    }

    public static Optional<Component> stopSpeedrun(ServerPlayer player) {
        SpeedrunRecord previousRecord = player.ns0$currentRecord();
        if (previousRecord == null) {
            return Optional.of(Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{player.getDisplayName()}));
        }
        if (player.ns0$serverRecordManager().getPlayerRole(previousRecord.recordId(), player) != PlayerRole.HOST) {
            return Optional.of(Component.translatable((String)"message.neospeedzero.stop.no_host"));
        }
        EventResult eventResult = ((NeoSpeedLifecycleEvents.ForceStopRecord)NeoSpeedLifecycleEvents.FORCE_STOP_RECORD.invoker()).onStop(player);
        if (eventResult == EventResult.interruptFalse()) {
            return Optional.of(Component.translatable((String)"message.neospeedzero.record.stop.force.cancel"));
        }
        SpeedrunRecordHolder prevHolder = player.ns0$serverRecordManager().endRecord(previousRecord.recordId());
        if (prevHolder == null) {
            return Optional.of(Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{player.getDisplayName()}));
        }
        NeoSpeedMessages.announceRecordForceStop(player, previousRecord);
        return Optional.empty();
    }

    public static Optional<Component> quitSpeedrun(ServerPlayer player) {
        SpeedrunRecordHolder holder = player.ns0$serverRecordManager().leaveRecord(player);
        if (holder != null) {
            NeoSpeedMessages.announceRecordQuit(player, holder.record());
            return Optional.empty();
        }
        return Optional.of(Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{player.getDisplayName()}));
    }

    public static Optional<Component> joinSpeedrun(ServerPlayer player, RecordReference ref) {
        SpeedrunRecord record = player.ns0$currentRecord();
        if (record != null) {
            return Optional.of(Component.translatable((String)"message.neospeedzero.record.start.started", (Object[])new Object[]{player.getDisplayName(), record.snapshot()}));
        }
        RecordManager manager = player.ns0$serverRecordManager();
        return (Optional)ref.parse(manager).map(uuid -> {
            Component msg = manager.joinRecord((UUID)uuid, player);
            if (msg == null) {
                SpeedrunRecordHolder holder = manager.findRecordByUuid((UUID)uuid);
                if (holder == null) {
                    return Optional.of(Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{player.getDisplayName()}));
                }
                NeoSpeedMessages.announceRecordJoin(player, holder.record());
                NeoSpeedLifecycle.initSpeedrunBeginning(player, holder.record());
            }
            return Optional.ofNullable(msg);
        }, Optional::of);
    }

    public static void viewRecord(ServerPlayer audience, @NotNull SpeedrunRecord record) {
        ChallengeSnapshot.fromRecord(record).sendToClient(audience);
    }

    public static void viewRecordRaw(ServerPlayer audience, @NotNull SpeedrunRecord record) {
        audience.sendSystemMessage(ChallengeSnapshot.fromRecord(record).toText());
    }

    public static void viewRecordDialog(ServerPlayer audience, @NotNull SpeedrunRecord record) {
        audience.openDialog(Holder.direct((Object)record.asDialog()));
    }

    public static void listDialog(ServerPlayer audience) {
        audience.openDialog(Holder.direct((Object)SpeedrunGoal.Holder.toDialog()));
    }

    public static void onInventoryChange(ServerPlayer player, ItemStack stack) {
        if (stack.isEmpty() || ItemExtensions.isModGivenItem(stack)) {
            return;
        }
        SpeedrunRecord record = player.ns0$currentRecord();
        if (record == null) {
            return;
        }
        int size = record.challenges().size();
        for (int i = 0; i < size; ++i) {
            if (record.collectedTimes()[i] >= 0L) continue;
            SpeedrunChallenge challenge = record.challenges().get(i);
            int idx = i;
            challenge.challenge().ifLeft(itemPredicate -> {
                if (itemPredicate.test(stack)) {
                    NeoSpeedLifecycle.onCompleteSingleChallenge(player, record, idx);
                }
            });
        }
    }

    private static void onAdvancementMade(ServerPlayer player, AdvancementHolder advancement) {
        SpeedrunRecord record = player.ns0$currentRecord();
        if (record == null) {
            return;
        }
        ABSDebug.debug(3, l -> l.info("Adv: {}", (Object)advancement.id()));
        int size = record.challenges().size();
        for (int i = 0; i < size; ++i) {
            if (record.collectedTimes()[i] >= 0L) continue;
            SpeedrunChallenge challenge = record.challenges().get(i);
            int idx = i;
            challenge.challenge().ifRight(advancementKey -> {
                ABSDebug.debug(3, l -> {
                    l.info("IsRight challenge[{}] which matches {}", (Object)idx, advancementKey);
                    l.info("Match: {}", (Object)advancement.id().equals((Object)advancementKey.location()));
                    l.info("===============");
                });
                if (advancement.id().equals((Object)advancementKey.location())) {
                    NeoSpeedLifecycle.onCompleteSingleChallenge(player, record, idx);
                }
            });
        }
    }

    public static void onCompleteSingleChallenge(ServerPlayer serverPlayer, SpeedrunRecord record, int index) {
        long currentTime = serverPlayer.ns0$time();
        record.markComplete(index, currentTime);
        new ChallengeSnapshot.Change(record.recordId(), index, currentTime).broadcastToAll(serverPlayer.level().getServer().getPlayerList());
        NeoSpeedMessages.announceChallengeComplete(serverPlayer, record, index, currentTime);
        ((NeoSpeedLifecycleEvents.CompleteSingleChallenge)NeoSpeedLifecycleEvents.COMPLETE_SINGLE_CHALLENGE.invoker()).onComplete(serverPlayer, record, index);
        if (record.shallComplete()) {
            NeoSpeedLifecycle.completeRecord(serverPlayer, record);
        }
    }

    static void completeRecord(ServerPlayer serverPlayer, SpeedrunRecord record) {
        long currentTime = serverPlayer.ns0$time();
        record.finishTime().setValue(currentTime);
        serverPlayer.ns0$serverRecordManager().endRecord(record.recordId());
        NeoSpeedMessages.announceRecordComplete(serverPlayer, record, currentTime);
        ((NeoSpeedLifecycleEvents.CompleteRecord)NeoSpeedLifecycleEvents.COMPLETE_RECORD.invoker()).onComplete(serverPlayer, record);
    }

    public static void register() {
        LifecycleEvent.SERVER_STARTING.register(server -> server.ns0$recordManager().loadFromServer());
        LifecycleEvent.SERVER_STOPPING.register(server -> server.ns0$recordManager().saveToServer());
        NeoSpeedLifecycle.registerAdvancementEvent(NeoSpeedLifecycle::onAdvancementMade);
        TickEvent.PLAYER_PRE.register(player -> {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            @Nullable UUID uuid = serverPlayer.ns0$serverRecordManager().findRecordIdByPlayer(serverPlayer);
            player.getInventory().forEach(stack -> {
                if (stack.isEmpty()) {
                    return;
                }
                if (ItemExtensions.matchesRecordId(stack, uuid)) {
                    return;
                }
                stack.setCount(0);
            });
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerAdvancementEvent(@NotNull PlayerEvent.PlayerAdvancement callback) {
        NeoSpeedLifecycleImpl.registerAdvancementEvent(callback);
    }
}

