/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.ApiStatus;
import xland.mcmod.neospeedzero.NeoSpeedGameRules;
import xland.mcmod.neospeedzero.record.SpeedrunChallenge;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.util.TimeUtil;

public final class NeoSpeedMessages {
    private NeoSpeedMessages() {
    }

    private static void announce(ServerPlayer serverPlayer, Component component) {
        MinecraftServer server = serverPlayer.level().getServer();
        boolean announceSpeedruns = server.getGameRules().getBoolean(NeoSpeedGameRules.ANNOUNCE_SPEEDRUNS);
        if (announceSpeedruns) {
            server.getPlayerList().broadcastSystemMessage(component, false);
        } else {
            serverPlayer.sendSystemMessage(component);
        }
    }

    static void announceRecordStart(ServerPlayer serverPlayer, SpeedrunRecord record) {
        NeoSpeedMessages.announce(serverPlayer, (Component)Component.translatable((String)"message.neospeedzero.record.start", (Object[])new Object[]{serverPlayer.getDisplayName(), record.snapshot()}));
    }

    static void announceRecordForceStop(ServerPlayer serverPlayer, SpeedrunRecord record) {
        NeoSpeedMessages.announce(serverPlayer, (Component)Component.translatable((String)"message.neospeedzero.record.stop.force", (Object[])new Object[]{serverPlayer.getDisplayName(), record.snapshot()}));
    }

    static void announceRecordQuit(ServerPlayer serverPlayer, SpeedrunRecord record) {
        NeoSpeedMessages.announce(serverPlayer, (Component)Component.translatable((String)"message.neospeedzero.join.unjoined", (Object[])new Object[]{serverPlayer.getDisplayName(), record.snapshot()}));
    }

    static void announceRecordJoin(ServerPlayer serverPlayer, SpeedrunRecord record) {
        NeoSpeedMessages.announce(serverPlayer, (Component)Component.translatable((String)"message.neospeedzero.join.success", (Object[])new Object[]{serverPlayer.getDisplayName(), record.snapshot()}));
    }

    static void announceChallengeComplete(ServerPlayer serverPlayer, SpeedrunRecord record, int index, long currentTime) {
        SpeedrunChallenge challenge = record.challenges().get(index);
        MinecraftServer server = serverPlayer.level().getServer();
        boolean announceSpeedruns = server.getGameRules().getBoolean(NeoSpeedGameRules.ANNOUNCE_SPEEDRUNS);
        MutableComponent component = Component.translatable((String)"message.neospeedzero.challenge.complete", (Object[])new Object[]{serverPlayer.getDisplayName(), record.snapshot(), challenge.icon().getDisplayName(), NeoSpeedMessages.progress(record), TimeUtil.duration(record, currentTime)});
        if (announceSpeedruns) {
            server.getPlayerList().broadcastSystemMessage((Component)component, false);
            server.getPlayerList().getPlayers().forEach(p -> NeoSpeedMessages.playSound(p, false));
        } else {
            serverPlayer.sendSystemMessage((Component)component);
            NeoSpeedMessages.playSound(serverPlayer, false);
        }
    }

    static void announceRecordComplete(ServerPlayer serverPlayer, SpeedrunRecord record, long currentTime) {
        MinecraftServer server = serverPlayer.level().getServer();
        boolean announceSpeedruns = server.getGameRules().getBoolean(NeoSpeedGameRules.ANNOUNCE_SPEEDRUNS);
        MutableComponent component = Component.translatable((String)"message.neospeedzero.record.complete", (Object[])new Object[]{serverPlayer.getDisplayName(), record.snapshot(), TimeUtil.duration(record, currentTime)});
        if (announceSpeedruns) {
            server.getPlayerList().broadcastSystemMessage((Component)component, false);
            server.getPlayerList().getPlayers().forEach(p -> NeoSpeedMessages.playSound(p, p.equals((Object)serverPlayer)));
        } else {
            serverPlayer.sendSystemMessage((Component)component);
            NeoSpeedMessages.playSound(serverPlayer, true);
        }
    }

    private static void playSound(ServerPlayer serverPlayer, boolean myWin) {
        SoundEvent soundEvent = myWin ? SoundEvents.UI_TOAST_CHALLENGE_COMPLETE : SoundEvents.EXPERIENCE_ORB_PICKUP;
        serverPlayer.playNotifySound(soundEvent, SoundSource.MASTER, 0.8f, 1.0f);
    }

    @ApiStatus.Internal
    public static Component snapshotFor(SpeedrunRecord record, boolean brackets) {
        MutableComponent component = Component.empty().append((Component)record.goal().goal().display().copy()).append((Component)Component.literal((String)("#" + record.recordId().toString().substring(0, 4))).withStyle(ChatFormatting.GRAY));
        if (brackets) {
            component = ComponentUtils.wrapInSquareBrackets((Component)component);
        }
        return component.withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText(NeoSpeedMessages.snapshotHover(record))));
    }

    private static Component snapshotHover(SpeedrunRecord record) {
        MutableComponent t = Component.empty();
        t.append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.goal_id", (Object[])new Object[]{String.valueOf(record.goal().id())})).append("\n");
        t.append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.difficulty", (Object[])new Object[]{record.difficulty().displayedName()})).append("\n");
        if (record.hasCompleted()) {
            t.append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.progress", (Object[])new Object[]{NeoSpeedMessages.progress(record).withStyle(ChatFormatting.GREEN)})).append("\n");
            t.append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.finish_time", (Object[])new Object[]{TimeUtil.duration(record, record.finishTime().longValue())})).append("\n");
        } else {
            t.append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.progress", (Object[])new Object[]{NeoSpeedMessages.progress(record).withStyle(ChatFormatting.RED)})).append("\n");
        }
        t.append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.id", (Object[])new Object[]{String.valueOf(record.recordId())})).append("\n");
        t.append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.non-synced").withStyle(ChatFormatting.GRAY));
        return t;
    }

    private static MutableComponent progress(SpeedrunRecord record) {
        return Component.translatable((String)"message.neospeedzero.record.snapshot.progress.data", (Object[])new Object[]{record.completedCount(), record.totalCount()});
    }
}

