/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import xland.mcmod.neospeedzero.NeoSpeedLifecycle;
import xland.mcmod.neospeedzero.api.SpeedrunDifficulties;
import xland.mcmod.neospeedzero.api.SpeedrunStartupConfig;
import xland.mcmod.neospeedzero.command.RecordReference;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.resource.SpeedrunGoal;

public class NeoSpeedCommands {
    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"neospeed").then(Commands.literal((String)"start").then(((RequiredArgumentBuilder)Commands.argument((String)"goal", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(SpeedrunGoal.Holder.holders().keySet(), (SuggestionsBuilder)builder)).executes(context -> {
            ResourceLocation goalId = ResourceLocationArgument.getId((CommandContext)context, (String)"goal");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            SpeedrunStartupConfig startupConfig = SpeedrunStartupConfig.builder().goal(goalId).build();
            NeoSpeedLifecycle.startSpeedrun(player, startupConfig).ifPresent(NeoSpeedCommands.sendFailure((CommandContext<CommandSourceStack>)context));
            return 1;
        })).then(Commands.argument((String)"difficulty", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(SpeedrunDifficulties.keys(), (SuggestionsBuilder)builder)).executes(context -> {
            ResourceLocation goalId = ResourceLocationArgument.getId((CommandContext)context, (String)"goal");
            ResourceLocation difficultyId = ResourceLocationArgument.getId((CommandContext)context, (String)"difficulty");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            SpeedrunStartupConfig startupConfig = SpeedrunStartupConfig.builder().goal(goalId).difficulty(difficultyId).build();
            NeoSpeedLifecycle.startSpeedrun(player, startupConfig).ifPresent(NeoSpeedCommands.sendFailure((CommandContext<CommandSourceStack>)context));
            return 1;
        }))))).then(Commands.literal((String)"stop").executes(context -> {
            NeoSpeedLifecycle.stopSpeedrun(((CommandSourceStack)context.getSource()).getPlayerOrException()).ifPresent(NeoSpeedCommands.sendFailure((CommandContext<CommandSourceStack>)context));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"view").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            SpeedrunRecord record = player.ns0$currentRecord();
            if (record == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{player.getDisplayName()}));
                return 0;
            }
            NeoSpeedLifecycle.viewRecord(player, record);
            return 1;
        })).then(Commands.literal((String)"raw").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            SpeedrunRecord record = player.ns0$currentRecord();
            if (record == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{player.getDisplayName()}));
                return 0;
            }
            NeoSpeedLifecycle.viewRecordRaw(player, record);
            return 1;
        }))).then(Commands.literal((String)"dialog").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            SpeedrunRecord record = player.ns0$currentRecord();
            if (record == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{player.getDisplayName()}));
                return 0;
            }
            NeoSpeedLifecycle.viewRecordDialog(player, record);
            return 1;
        })))).then(Commands.literal((String)"list").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            NeoSpeedLifecycle.listDialog(player);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"join").then(Commands.literal((String)"player").then(Commands.argument((String)"maybeHost", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer me = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            ServerPlayer maybeHost = EntityArgument.getPlayer((CommandContext)context, (String)"maybeHost");
            NeoSpeedLifecycle.joinSpeedrun(me, RecordReference.ofPlayer(maybeHost)).ifPresent(NeoSpeedCommands.sendFailure((CommandContext<CommandSourceStack>)context));
            return 1;
        })))).then(Commands.literal((String)"record").then(Commands.argument((String)"reference", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            ((CommandSourceStack)context.getSource()).getServer().ns0$recordManager().getAllRecordIds().forEach(uuid -> builder.suggest(uuid.toString()));
            return builder.buildFuture();
        }).executes(context -> {
            ServerPlayer me = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            RecordReference ref = RecordReference.of(StringArgumentType.getString((CommandContext)context, (String)"reference"));
            NeoSpeedLifecycle.joinSpeedrun(me, ref).ifPresent(NeoSpeedCommands.sendFailure((CommandContext<CommandSourceStack>)context));
            return 1;
        }))))).then(Commands.literal((String)"quit").executes(context -> {
            NeoSpeedLifecycle.quitSpeedrun(((CommandSourceStack)context.getSource()).getPlayerOrException()).ifPresent(NeoSpeedCommands.sendFailure((CommandContext<CommandSourceStack>)context));
            return 1;
        }))));
    }

    private static Consumer<Component> sendFailure(CommandContext<CommandSourceStack> context) {
        return component -> ((CommandSourceStack)context.getSource()).sendFailure(component);
    }
}

