/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.command;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.neospeedzero.command.RecordReference;
import xland.mcmod.neospeedzero.record.manager.RecordManager;

record RecordLookup(String prefix) implements RecordReference
{
    @Override
    public Either<UUID, Component> parse(RecordManager manager) {
        List<UUID> uuids = manager.getAllRecordIds().stream().filter(uuid -> uuid.toString().startsWith(this.prefix())).toList();
        return switch (uuids.size()) {
            case 0 -> Either.right((Object)Component.translatable((String)"message.neospeedzero.record.not_found", (Object[])new Object[]{this.toString()}));
            case 1 -> Either.left((Object)uuids.getFirst());
            default -> Either.right((Object)Component.translatable((String)"message.neospeedzero.record.ambiguous", (Object[])new Object[]{this.toString()}));
        };
    }

    @Override
    @NotNull
    public String toString() {
        return "#" + this.prefix();
    }

    static RecordReference of(String s) {
        try {
            return new Definite(UUID.fromString(s));
        }
        catch (IllegalArgumentException e) {
            if (!s.matches("^[0-9A-Fa-f]{4}$")) {
                return new Failure((Component)Component.translatable((String)"message.neospeedzero.record.invalid_ref", (Object[])new Object[]{s}));
            }
            return new RecordLookup(s.toLowerCase(Locale.ROOT));
        }
    }

    static RecordReference ofPlayer(ServerPlayer targetPlayer) {
        return new PlayerBased(targetPlayer);
    }

    record Definite(UUID uuid) implements RecordReference
    {
        @Override
        public Either<UUID, Component> parse(RecordManager manager) {
            return Either.left((Object)this.uuid());
        }
    }

    record Failure(Component message) implements RecordReference
    {
        @Override
        public Either<UUID, Component> parse(RecordManager manager) {
            return Either.right((Object)this.message());
        }
    }

    record PlayerBased(ServerPlayer player) implements RecordReference
    {
        @Override
        public Either<UUID, Component> parse(RecordManager manager) {
            UUID uuid = manager.findRecordIdByPlayer(this.player());
            return uuid != null ? Either.left((Object)uuid) : Either.right((Object)Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{this.player.getDisplayName()}));
        }
    }
}

