/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.difficulty;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.neospeedzero.difficulty.SpeedrunDifficulty;
import xland.mcmod.neospeedzero.itemext.ItemExtensions;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;

public enum BuiltinDifficulty implements SpeedrunDifficulty
{
    NN(GiveItem.NONE, GiveItem.NONE, "empty"),
    NC(GiveItem.NONE, GiveItem.COMMON, "elytra"),
    NU(GiveItem.NONE, GiveItem.UNBREAKABLE, "inf_elytra"),
    CN(GiveItem.COMMON, GiveItem.NONE, "firework"),
    CC(GiveItem.COMMON, GiveItem.COMMON, "firework_elytra"),
    CU(GiveItem.COMMON, GiveItem.UNBREAKABLE, "firework_inf_elytra"),
    UN(GiveItem.UNBREAKABLE, GiveItem.NONE, "inf_firework"),
    UC(GiveItem.UNBREAKABLE, GiveItem.COMMON, "inf_firework_elytra"),
    UU(GiveItem.UNBREAKABLE, GiveItem.UNBREAKABLE, "inf_firework_inf_elytra");

    private final String rawId;
    private final GiveItem forFirework;
    private final GiveItem forElytra;

    private BuiltinDifficulty(GiveItem forFirework, GiveItem forElytra, String rawId) {
        this.rawId = rawId;
        this.forFirework = forFirework;
        this.forElytra = forElytra;
    }

    @Override
    @NotNull
    public ResourceLocation id() {
        return ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)this.rawId);
    }

    @Override
    @NotNull
    public Component displayedName() {
        return Component.translatable((String)("message.neospeedzero.difficulty." + this.rawId));
    }

    @Override
    public void onStart(ServerPlayer player, SpeedrunRecord record) {
        this.giveItems(player, record);
    }

    private void giveItems(ServerPlayer player, SpeedrunRecord record) {
        ItemExtensions.give(player, this.forFirework.createFirework(record.recordId()));
        ItemExtensions.give(player, this.forElytra.createElytra(record.recordId()));
    }

    private static enum GiveItem {
        NONE(recordId -> null, recordId -> null),
        COMMON(ItemExtensions::commonFireworks, ItemExtensions::commonElytra),
        UNBREAKABLE(ItemExtensions::infiniteFireworks, ItemExtensions::infiniteElytra);

        private final Function<UUID, @Nullable ItemStack> fireworkFactory;
        private final Function<UUID, @Nullable ItemStack> elytraFactory;

        private GiveItem(Function<UUID, ItemStack> fireworkFactory, Function<UUID, ItemStack> elytraFactory) {
            this.fireworkFactory = fireworkFactory;
            this.elytraFactory = elytraFactory;
        }

        @NotNull
        ItemStack createFirework(UUID recordId) {
            return Objects.requireNonNullElse(this.fireworkFactory.apply(recordId), ItemStack.EMPTY);
        }

        @NotNull
        ItemStack createElytra(UUID recordId) {
            return Objects.requireNonNullElse(this.elytraFactory.apply(recordId), ItemStack.EMPTY);
        }
    }
}

