/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.itemext;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.neospeedzero.mixin.CustomDataAccessor;

public interface ItemExtensions {
    public static final String TAG_MOD_GIVEN = "neospeedzero_given_item";
    public static final String TAG_INFINITE_FIREWORK = "infinite_firework";

    public static ItemStack commonFireworks(UUID recordId) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 64);
        ItemExtensions.patchModGiven(itemStack, recordId);
        return itemStack;
    }

    public static ItemStack infiniteFireworks(UUID recordId) {
        ItemStack itemStack = ItemExtensions.commonFireworks(recordId);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemStack, tag -> tag.putBoolean(TAG_INFINITE_FIREWORK, true));
        return itemStack;
    }

    public static ItemStack commonElytra(UUID recordId) {
        ItemStack itemStack = Items.ELYTRA.getDefaultInstance();
        ItemExtensions.patchModGiven(itemStack, recordId);
        return itemStack;
    }

    public static ItemStack infiniteElytra(UUID recordId) {
        ItemStack itemStack = ItemExtensions.commonElytra(recordId);
        itemStack.set(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
        return itemStack;
    }

    private static void patchModGiven(ItemStack stack, UUID recordId) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putIntArray(TAG_MOD_GIVEN, UUIDUtil.uuidToIntArray((UUID)recordId)));
        stack.update(DataComponents.LORE, (Object)ItemLore.EMPTY, lore -> lore.withLineAdded((Component)Component.translatable((String)"message.neospeedzero.item.mod_given")));
    }

    public static boolean matchesRecordId(ItemStack stack, @Nullable UUID recordId) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return true;
        }
        CompoundTag rawTag = ((CustomDataAccessor)customData).ns0$getUnsafe();
        Optional intArray = rawTag.getIntArray(TAG_MOD_GIVEN);
        return intArray.map(ints -> recordId != null && Arrays.equals(ints, UUIDUtil.uuidToIntArray((UUID)recordId))).orElse(true);
    }

    public static boolean isModGivenItem(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return false;
        }
        return ((CustomDataAccessor)customData).ns0$getUnsafe().contains(TAG_MOD_GIVEN);
    }

    public static boolean isInfiniteFirework(ItemStack stack) {
        if (!stack.is(Items.FIREWORK_ROCKET)) {
            return false;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return false;
        }
        CompoundTag rawTag = ((CustomDataAccessor)customData).ns0$getUnsafe();
        return rawTag.getBooleanOr(TAG_INFINITE_FIREWORK, false);
    }

    public static void give(@NotNull ServerPlayer player, @NotNull ItemStack stack) {
        if (!player.addItem(stack)) {
            player.drop(stack, true);
        }
    }
}

