/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.neoforge;

import com.google.common.base.Preconditions;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public final class NeoSpeedLifecycleImpl {
    private static final AtomicReference<PlayerEvent.PlayerAdvancement> theCallbackRef = new AtomicReference();

    public static void registerAdvancementEvent(@NotNull PlayerEvent.PlayerAdvancement callback) {
        Preconditions.checkNotNull((Object)callback, (Object)"Callback must not be null");
        if (!theCallbackRef.compareAndSet(null, callback)) {
            throw new IllegalStateException("theCallback is initialized twice");
        }
    }

    public static void onAdvancementMade(ServerPlayer player, AdvancementHolder holder) {
        PlayerEvent.PlayerAdvancement callback = theCallbackRef.get();
        Preconditions.checkState((callback != null ? 1 : 0) != 0, (Object)"theCallback is not initialized yet");
        callback.award(player, holder);
    }

    private NeoSpeedLifecycleImpl() {
    }
}

