/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.record;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.neospeedzero.resource.StatedIcon;

public record SpeedrunChallenge(Either<ItemPredicate, ResourceKey<Advancement>> challenge, ItemStack icon) {
    public static final Codec<SpeedrunChallenge> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.dispatch(Type::fromEither, Type::toMapCodec).fieldOf("challenge").forGetter(SpeedrunChallenge::challenge), (App)ItemStack.CODEC.fieldOf("icon").forGetter(SpeedrunChallenge::icon)).apply((Applicative)instance, SpeedrunChallenge::new));

    public static SpeedrunChallenge of(Either<ItemPredicate, ResourceKey<Advancement>> challenge, ItemStack generatedIcon, @Nullable StatedIcon statedIcon) {
        if (statedIcon == null) {
            return new SpeedrunChallenge(challenge, generatedIcon);
        }
        ItemStack statedIconStack = statedIcon.icon().copy();
        statedIcon.iconState().accept(statedIconStack, generatedIcon);
        return new SpeedrunChallenge(challenge, statedIconStack);
    }

    public static SpeedrunChallenge of(Either<ItemPredicate, ResourceKey<Advancement>> challenge, ItemStack generatedIcon, Optional<StatedIcon> statedIcon) {
        return SpeedrunChallenge.of(challenge, generatedIcon, statedIcon.orElse(null));
    }

    private static enum Type implements StringRepresentable
    {
        ITEM_PREDICATE("item"),
        ADVANCEMENT("advancement");

        private final String id;
        private static final StringRepresentable.EnumCodec<Type> CODEC;

        private Type(String id) {
            this.id = id;
        }

        @NotNull
        public String getSerializedName() {
            return this.id;
        }

        @NotNull
        private static Type fromEither(Either<ItemPredicate, ResourceKey<Advancement>> either) {
            return either.left().isPresent() ? ITEM_PREDICATE : ADVANCEMENT;
        }

        private MapCodec<Either<ItemPredicate, ResourceKey<Advancement>>> toMapCodec() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ItemPredicate.CODEC.flatComapMap(Either::left, either -> (DataResult)either.map(DataResult::success, r -> this.errorResult())).fieldOf("item");
                case 1 -> ResourceKey.codec((ResourceKey)Registries.ADVANCEMENT).flatComapMap(Either::right, either -> (DataResult)either.map(l -> this.errorResult(), DataResult::success)).fieldOf("advancement");
            };
        }

        private <T> DataResult<T> errorResult() {
            return DataResult.error(() -> "Expected " + this.getSerializedName() + ", got another");
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

