/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.record;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.neospeedzero.api.SpeedrunDifficulties;
import xland.mcmod.neospeedzero.api.SpeedrunStartupConfig;
import xland.mcmod.neospeedzero.difficulty.SpeedrunDifficulty;
import xland.mcmod.neospeedzero.record.SpeedrunChallenge;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.resource.GoalPredicate;
import xland.mcmod.neospeedzero.resource.SpeedrunGoal;

public record SpeedrunStartupConfigImpl(SpeedrunGoal.Holder goal, SpeedrunDifficulty difficulty, UUID recordId) implements SpeedrunStartupConfig
{
    @Override
    public SpeedrunRecord createRecord(long currentTime) {
        SpeedrunGoal.Holder goal = this.goal();
        List<SpeedrunChallenge> challenges = goal.goal().predicates().stream().flatMap(GoalPredicate::stream).toList();
        return new SpeedrunRecord(goal, this.recordId(), challenges, currentTime, this.difficulty());
    }

    public static final class BuilderImpl
    implements SpeedrunStartupConfig.Builder {
        private SpeedrunGoal.Holder goal;
        @NotNull
        private SpeedrunDifficulty difficulty = SpeedrunDifficulty.getDefault();
        private static final DynamicCommandExceptionType EX_INVALID_GOAL = new DynamicCommandExceptionType(obj -> Component.translatable((String)"command.neospeedzero.not_found.goal", (Object[])new Object[]{String.valueOf(obj)}));
        private static final DynamicCommandExceptionType EX_INVALID_DIFFICULTY = new DynamicCommandExceptionType(obj -> Component.translatable((String)"command.neospeedzero.not_found.difficulty", (Object[])new Object[]{String.valueOf(obj)}));

        @Override
        public SpeedrunStartupConfig.Builder goal( @NotNull SpeedrunGoal.Holder goal) {
            Objects.requireNonNull(goal, "goal");
            this.goal = goal;
            return this;
        }

        @Override
        public SpeedrunStartupConfig.Builder difficulty(@NotNull SpeedrunDifficulty difficulty) {
            Objects.requireNonNull(difficulty, "difficulty");
            this.difficulty = difficulty;
            return this;
        }

        @Override
        public SpeedrunStartupConfig build() {
            Objects.requireNonNull(this.goal, "Missing goal");
            UUID recordId = UUID.randomUUID();
            return new SpeedrunStartupConfigImpl(this.goal, this.difficulty, recordId);
        }

        @Override
        public SpeedrunStartupConfig.Builder goal(ResourceLocation id) throws CommandSyntaxException {
            SpeedrunGoal.Holder holder = SpeedrunGoal.Holder.holders().get(id);
            if (holder == null) {
                throw EX_INVALID_GOAL.create((Object)id);
            }
            return this.goal(holder);
        }

        @Override
        public SpeedrunStartupConfig.Builder difficulty(ResourceLocation id) throws CommandSyntaxException {
            SpeedrunDifficulty speedrunDifficulty = SpeedrunDifficulties.get(id);
            if (speedrunDifficulty == null) {
                throw EX_INVALID_DIFFICULTY.create((Object)id);
            }
            return this.difficulty(speedrunDifficulty);
        }
    }
}

