/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.record.manager;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.record.manager.NeoSpeedPlayer;
import xland.mcmod.neospeedzero.record.manager.PlayerRole;
import xland.mcmod.neospeedzero.record.manager.SaveInfo;
import xland.mcmod.neospeedzero.record.manager.SpeedrunPlayerInfo;
import xland.mcmod.neospeedzero.record.manager.SpeedrunRecordHolder;
import xland.mcmod.neospeedzero.util.StreamIoUtil;

public class RecordManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<UUID, UUID> playerToRecordMap = new LinkedHashMap<UUID, UUID>();
    private final Map<UUID, SpeedrunRecordHolder> recordMap = new LinkedHashMap<UUID, SpeedrunRecordHolder>();
    private final MinecraftServer server;
    private static final Thread.Builder THREAD_BUILDER = Thread.ofVirtual().name("History-Record-Saver-", 1L);
    private static final LevelResource LEVEL_RESOURCE = new LevelResource("neospeedzero");

    public RecordManager(MinecraftServer server) {
        this.server = server;
    }

    private void bindHost(SpeedrunRecord record, ServerPlayer host) {
        this.recordMap.put(record.recordId(), new SpeedrunRecordHolder(record, new SpeedrunPlayerInfo(host.getUUID())));
    }

    private void registerTo(ServerPlayer player, SpeedrunRecord record) {
        this.playerToRecordMap.put(player.getUUID(), record.recordId());
    }

    @Nullable
    public Component startHosting(SpeedrunRecord record, ServerPlayer host) {
        if (this.playerToRecordMap.containsKey(host.getUUID())) {
            return Component.translatable((String)"message.neospeedzero.record.start.started", (Object[])new Object[]{host.getDisplayName(), record.snapshot()});
        }
        this.bindHost(record, host);
        this.registerTo(host, record);
        return null;
    }

    @Nullable
    public Component joinRecord(UUID recordId, ServerPlayer subPlayer) {
        UUID prevRecordId = this.findRecordIdByPlayer(subPlayer);
        if (prevRecordId != null) {
            SpeedrunRecordHolder holder = this.findRecordByUuid(prevRecordId);
            return Component.translatable((String)"message.neospeedzero.record.start.started", (Object[])new Object[]{subPlayer.getDisplayName(), holder == null ? "<???>" : holder.record().snapshot()});
        }
        SpeedrunRecordHolder holder = this.findRecordByUuid(recordId);
        if (holder == null) {
            return Component.translatable((String)"message.neospeedzero.record.not_found", (Object[])new Object[]{recordId.toString()});
        }
        holder.info().participants().add(subPlayer.getUUID());
        this.registerTo(subPlayer, holder.record());
        return null;
    }

    @Nullable
    public UUID findRecordIdByPlayer(ServerPlayer player) {
        return this.findRecordIdByPlayer(player.getUUID());
    }

    @Nullable
    public UUID findRecordIdByPlayer(UUID playerId) {
        return this.playerToRecordMap.get(playerId);
    }

    @Nullable
    public SpeedrunRecordHolder findRecordByPlayer(ServerPlayer player) {
        return this.findRecordByPlayer(player.getUUID());
    }

    @Nullable
    public SpeedrunRecordHolder findRecordByPlayer(UUID playerId) {
        @Nullable UUID recordId = this.findRecordIdByPlayer(playerId);
        return recordId == null ? null : this.recordMap.get(recordId);
    }

    @Nullable
    public SpeedrunRecordHolder findRecordByUuid(UUID recordId) {
        return this.recordMap.get(recordId);
    }

    public @UnmodifiableView Set<UUID> getAllRecordIds() {
        return Collections.unmodifiableSet(this.recordMap.keySet());
    }

    public PlayerRole getPlayerRole(@Nullable UUID recordId, ServerPlayer player) {
        SpeedrunRecordHolder holder;
        SpeedrunRecordHolder speedrunRecordHolder = holder = recordId == null ? this.findRecordByPlayer(player) : this.findRecordByUuid(recordId);
        if (holder == null) {
            return PlayerRole.NONE;
        }
        return holder.info().getPlayerRole(player.getUUID());
    }

    @Nullable
    public SpeedrunRecordHolder endRecord(UUID recordId) {
        SpeedrunRecordHolder holder = this.findRecordByUuid(recordId);
        if (holder == null) {
            return null;
        }
        this.endRecord(holder);
        return holder;
    }

    public void endRecord(SpeedrunRecordHolder holder) {
        this.playerToRecordMap.keySet().removeAll(holder.info().getAllPlayers());
        this.recordMap.remove(holder.record().recordId());
        this.saveHistoricalRecordAsync(holder);
    }

    @Nullable
    public SpeedrunRecordHolder leaveRecord(ServerPlayer player) {
        return this.leaveRecord(player.getUUID());
    }

    @Nullable
    public SpeedrunRecordHolder leaveRecord(UUID playerId) {
        SpeedrunRecordHolder holder = this.findRecordByPlayer(playerId);
        if (holder == null) {
            return null;
        }
        return switch (holder.info().getPlayerRole(playerId)) {
            case PlayerRole.HOST -> {
                this.endRecord(holder);
                yield holder;
            }
            case PlayerRole.PARTICIPANT -> {
                if (holder.info().participants().remove(playerId)) {
                    this.playerToRecordMap.remove(playerId);
                    yield holder;
                }
                yield null;
            }
            default -> null;
        };
    }

    @Contract(pure=true)
    @VisibleForTesting
    public Snapshot snapshot(boolean onServerSave) {
        return new Snapshot(new SaveInfo(onServerSave), this.recordMap.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((SpeedrunRecordHolder)e.getValue()).info())), this.playerToRecordMap, this.recordMap.values().stream().map(SpeedrunRecordHolder::record).collect(Collectors.toUnmodifiableSet()));
    }

    private void saveHistoricalRecordAsync(SpeedrunRecordHolder holder) {
        THREAD_BUILDER.start(() -> {
            try {
                RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.server.registryAccess());
                CompoundTag compound = (CompoundTag)((Tag)SpeedrunRecordHolder.CODEC.encodeStart((DynamicOps)ops, (Object)holder).getOrThrow()).asCompound().orElseThrow(() -> new IllegalStateException("Not a compound"));
                String recordIdString = holder.record().recordId().toString();
                Path path = this.serverDir().resolve("historical_records").resolve(recordIdString.substring(0, 2)).resolve(recordIdString + ".dat");
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                NbtIo.writeCompressed((CompoundTag)compound, (Path)path);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save historical record {}", (Object)holder.record().recordId(), (Object)e);
            }
        });
    }

    @ApiStatus.Internal
    public void registerLegacyRecord(NeoSpeedPlayer player, SpeedrunRecord record) {
        this.startHosting(record, (ServerPlayer)player);
    }

    public void loadFromServer() {
        Snapshot snapshot;
        Path path = this.serverDir().resolve("PlayerRecords.dat");
        try {
            byte[] buf;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                return;
            }
            try (BufferedInputStream input = new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]))));){
                buf = input.readAllBytes();
            }
            snapshot = (Snapshot)Snapshot.STREAM_CODEC.decode((Object)StreamIoUtil.byteBuf(buf, (RegistryAccess)this.server.registryAccess()));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load NeoSpeedZero player records", (Throwable)e);
            return;
        }
        snapshot.loadTo(this);
    }

    public void saveToServer() {
        Path path = this.serverDir().resolve("PlayerRecords.dat");
        Path backup = this.serverDir().resolve("PlayerRecords.dat_old");
        try {
            RegistryFriendlyByteBuf byteBuf = StreamIoUtil.byteBuf(null, (RegistryAccess)this.server.registryAccess());
            Snapshot.STREAM_CODEC.encode((Object)byteBuf, (Object)this.snapshot(false));
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)byteBuf);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path tempFile = Files.createTempFile("PlayerRecords", "dat", new FileAttribute[0]);
            try (BufferedOutputStream output = new BufferedOutputStream(new GZIPOutputStream(new BufferedOutputStream(Files.newOutputStream(tempFile, new OpenOption[0]))));){
                output.write(bytes);
            }
            Util.safeReplaceFile((Path)path, (Path)tempFile, (Path)backup);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save NeoSpeed Zero player records", (Throwable)e);
        }
    }

    private Path serverDir() {
        return this.server.getWorldPath(LEVEL_RESOURCE);
    }

    public record Snapshot(SaveInfo saveInfo, @Unmodifiable Map<UUID, SpeedrunPlayerInfo> infos, @Unmodifiable Map<UUID, UUID> playerToRecordIdMap, @Unmodifiable Set<SpeedrunRecord> records) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Snapshot> STREAM_CODEC = StreamCodec.composite(SaveInfo.STREAM_CODEC, Snapshot::saveInfo, StreamIoUtil.ofMap(UUIDUtil.STREAM_CODEC, SpeedrunPlayerInfo.STREAM_CODEC), Snapshot::infos, StreamIoUtil.ofMap(UUIDUtil.STREAM_CODEC, UUIDUtil.STREAM_CODEC), Snapshot::playerToRecordIdMap, StreamIoUtil.ofJsonArrayString(SpeedrunRecord.CODEC, LinkedHashSet::new), Snapshot::records, Snapshot::new);

        private void loadTo(RecordManager manager) {
            LinkedHashMap<UUID, SpeedrunRecordHolder> recordMap = new LinkedHashMap<UUID, SpeedrunRecordHolder>();
            for (SpeedrunRecord record : this.records()) {
                UUID recordId = record.recordId();
                SpeedrunPlayerInfo info = this.infos().get(recordId);
                if (info == null) {
                    throw new NoSuchElementException("info is absent");
                }
                recordMap.put(recordId, new SpeedrunRecordHolder(record, info));
            }
            manager.recordMap.clear();
            manager.recordMap.putAll(recordMap);
            manager.playerToRecordMap.clear();
            manager.playerToRecordMap.putAll(this.playerToRecordIdMap());
        }
    }
}

