/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.record.manager;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import xland.mcmod.neospeedzero.record.manager.PlayerRole;

public record SpeedrunPlayerInfo(UUID host, Set<UUID> participants) {
    public static final StreamCodec<ByteBuf, SpeedrunPlayerInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SpeedrunPlayerInfo::host, (StreamCodec)ByteBufCodecs.collection(LinkedHashSet::new, (StreamCodec)UUIDUtil.STREAM_CODEC), SpeedrunPlayerInfo::participants, SpeedrunPlayerInfo::new);
    public static final MapCodec<SpeedrunPlayerInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("host").forGetter(SpeedrunPlayerInfo::host), (App)UUIDUtil.CODEC_LINKED_SET.fieldOf("participants").forGetter(SpeedrunPlayerInfo::participants)).apply((Applicative)instance, SpeedrunPlayerInfo::new));

    public SpeedrunPlayerInfo(UUID host) {
        this(host, new LinkedHashSet<UUID>());
    }

    @Contract(pure=true)
    public @UnmodifiableView Set<UUID> getAllPlayers() {
        return ImmutableSet.builderWithExpectedSize((int)(this.participants().size() + 1)).add((Object)this.host()).addAll(this.participants()).build();
    }

    public PlayerRole getPlayerRole(@NotNull UUID playerId) {
        if (Objects.equals(playerId, this.host())) {
            return PlayerRole.HOST;
        }
        if (this.participants().contains(playerId)) {
            return PlayerRole.PARTICIPANT;
        }
        return PlayerRole.NONE;
    }
}

