/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.resource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.neospeedzero.record.SpeedrunChallenge;
import xland.mcmod.neospeedzero.resource.ExtraRequirements;
import xland.mcmod.neospeedzero.resource.GoalPredicate;
import xland.mcmod.neospeedzero.resource.StatedIcon;

final class ItemGoalPredicate
extends GoalPredicate.OfItemPredicate {
    @NotNull
    private final HolderSet<Item> items;
    @NotNull
    private final Select select;
    public static final Codec<ItemGoalPredicate> CODEC = ItemGoalPredicate.createCodec();

    ItemGoalPredicate(@NotNull HolderSet<Item> items, @NotNull Select select, Optional<StatedIcon> statedIcon, Optional<ItemPredicate> subPredicate) {
        super(statedIcon, subPredicate);
        this.items = items;
        this.select = select;
    }

    static ItemGoalPredicate of(@NotNull HolderSet<Item> items) {
        return new ItemGoalPredicate(items, Select.ALL, Optional.empty(), Optional.empty());
    }

    private static Codec<ItemGoalPredicate> createCodec() {
        Codec baseCodec = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).fieldOf("items").forGetter(ItemGoalPredicate::items), (App)Select.CODEC.optionalFieldOf("select", (Object)Select.ALL).forGetter(p -> p.select), (App)StatedIcon.CODEC.optionalFieldOf("icon").forGetter(GoalPredicate.OfItemPredicate::icon), (App)ItemPredicate.CODEC.optionalFieldOf("item_predicate").forGetter(p -> Optional.ofNullable(p.subPredicate))).apply((Applicative)instance, ItemGoalPredicate::new));
        return Codec.withAlternative((Codec)baseCodec, (Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM), ItemGoalPredicate::of);
    }

    @NotNull
    private HolderSet<Item> items() {
        return this.items;
    }

    @Override
    public Stream<SpeedrunChallenge> stream() {
        return switch (this.select.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ItemPredicate newPredicate = new ItemPredicate(Optional.of(this.items()), this.subPredicate != null ? this.subPredicate.count() : MinMaxBounds.Ints.ANY, this.subPredicate != null ? this.subPredicate.components() : DataComponentMatchers.ANY);
                ItemStack generatedIcon = ItemGoalPredicate.theAnyApple();
                ExtraRequirements.fillExtraRequirements(generatedIcon, (Either<TagKey<Item>, HolderSet<Item>>)this.items().unwrap().mapRight(HolderSet::direct), this.subPredicate);
                yield Stream.of(SpeedrunChallenge.of((Either<ItemPredicate, ResourceKey<Advancement>>)Either.left((Object)newPredicate), generatedIcon, this.icon()));
            }
            case 1 -> this.items().stream().map(itemHolder -> {
                ItemStack generatedIcon = new ItemStack(itemHolder);
                HolderSet.Direct holderSet = HolderSet.direct((Holder[])new Holder[]{itemHolder});
                ItemPredicate newPredicate = new ItemPredicate(Optional.of(holderSet), this.subPredicate != null ? this.subPredicate.count() : MinMaxBounds.Ints.ANY, this.subPredicate != null ? this.subPredicate.components() : DataComponentMatchers.ANY);
                ExtraRequirements.fillExtraRequirements(generatedIcon, null, this.subPredicate);
                return SpeedrunChallenge.of((Either<ItemPredicate, ResourceKey<Advancement>>)Either.left((Object)newPredicate), generatedIcon, this.icon());
            });
        };
    }

    static enum Select implements StringRepresentable
    {
        ANY("any"),
        ALL("all");

        private final String id;
        static final StringRepresentable.EnumCodec<Select> CODEC;

        private Select(String id) {
            this.id = id;
        }

        @NotNull
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Select::values);
        }
    }
}

