/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.resource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.ActionButton;
import net.minecraft.server.dialog.ConfirmationDialog;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.NoticeDialog;
import net.minecraft.server.dialog.action.StaticAction;
import net.minecraft.server.dialog.body.DialogBody;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.server.dialog.input.SingleOptionInput;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import xland.mcmod.neospeedzero.api.SpeedrunDifficulties;
import xland.mcmod.neospeedzero.difficulty.SpeedrunDifficulty;
import xland.mcmod.neospeedzero.resource.GoalPredicate;
import xland.mcmod.neospeedzero.util.DialogUtil;

public record SpeedrunGoal(ItemStack icon, Component display, List<GoalPredicate> predicates) {
    public static final Codec<SpeedrunGoal> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("icon").forGetter(SpeedrunGoal::icon), (App)ComponentSerialization.CODEC.fieldOf("display").forGetter(SpeedrunGoal::display), (App)GoalPredicate.CODEC.listOf().fieldOf("predicates").forGetter(SpeedrunGoal::predicates)).apply((Applicative)instance, SpeedrunGoal::new));
    public static final Codec<Holder> HOLDER_CODEC = Codec.lazyInitialized(() -> ResourceLocation.CODEC.comapFlatMap(id -> Optional.ofNullable(Holder.holders().get(id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find SpeedrunGoal.Holder " + String.valueOf(id))), Holder::id));

    public record Holder(ResourceLocation id, SpeedrunGoal goal) implements Comparable<Holder>
    {
        private static volatile Map<ResourceLocation, Holder> wrappedHolders = Collections.emptyMap();

        public static @Unmodifiable Map<ResourceLocation, Holder> holders() {
            return Collections.unmodifiableMap(wrappedHolders);
        }

        public static void clearHolders() {
            wrappedHolders = Collections.emptyMap();
        }

        public static void setHolders(Map<ResourceLocation, Holder> holders) {
            wrappedHolders = holders;
        }

        @Override
        public int compareTo(@NotNull Holder o) {
            int result = this.id.getNamespace().compareTo(o.id.getNamespace());
            if (result == 0) {
                result = this.id.getPath().compareTo(o.id.getPath());
            }
            return result;
        }

        public static Dialog toDialog() {
            List<DialogBody> dialogBodies = wrappedHolders.values().stream().sorted().map(holder -> DialogUtil.itemBody(holder.goal().icon(), (Component)holder.goal().display().copy().withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.ShowDialog(net.minecraft.core.Holder.direct((Object)holder.configDialog())))))).toList();
            return new NoticeDialog(DialogUtil.commonDialogData((Component)Component.translatable((String)"gui.neospeedzero.goals"), true, dialogBodies), NoticeDialog.DEFAULT_ACTION);
        }

        private Dialog configDialog() {
            List<SingleOptionInput.Entry> entries = SpeedrunDifficulties.entries().stream().map(entry -> new SingleOptionInput.Entry(((ResourceLocation)entry.getKey()).toString(), Optional.of(((SpeedrunDifficulty)entry.getValue()).displayedName()), entry.getValue() == SpeedrunDifficulty.getDefault())).toList();
            return new ConfirmationDialog(DialogUtil.commonDialogData((Component)Component.translatable((String)"gui.neospeedzero.startup_goal", (Object[])new Object[]{this.goal().display()}), Collections.singletonList(new Input("difficulty", (InputControl)DialogUtil.singleOptionInput((Component)Component.translatable((String)"gui.neospeedzero.select_difficulty"), entries)))), new ActionButton(DialogUtil.commonButtonData(CommonComponents.GUI_PROCEED), Optional.of(DialogUtil.commandTemplate("/neospeed start " + String.valueOf(this.id()) + " $(difficulty)"))), new ActionButton(DialogUtil.commonButtonData(CommonComponents.GUI_CANCEL), Optional.of(new StaticAction((ClickEvent)new ClickEvent.RunCommand("/neospeed list")))));
        }
    }
}

