/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.resource.loader;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import xland.mcmod.neospeedzero.resource.SpeedrunGoal;
import xland.mcmod.neospeedzero.resource.loader.neoforge.SpeedrunGoalManagerImpl;
import xland.mcmod.neospeedzero.util.ABSDebug;

public class SpeedrunGoalManager
extends SimpleJsonResourceReloadListener<SpeedrunGoal> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation GOAL_KEY_ID = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"goals");
    public static final ResourceKey<Registry<SpeedrunGoal>> GOAL_KEY = ResourceKey.createRegistryKey((ResourceLocation)GOAL_KEY_ID);

    private SpeedrunGoalManager(HolderLookup.Provider provider) {
        super(provider, SpeedrunGoal.CODEC, GOAL_KEY);
    }

    public static void registerEvents() {
        SpeedrunGoalManager.register(SpeedrunGoalManager::new);
        LifecycleEvent.SERVER_STOPPED.register(server -> {
            LOGGER.info("Clearing SpeedRunGoal.Holder");
            SpeedrunGoal.Holder.clearHolders();
        });
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void register(Function<HolderLookup.Provider, SpeedrunGoalManager> factory) {
        SpeedrunGoalManagerImpl.register(factory);
    }

    protected void apply(Map<ResourceLocation, SpeedrunGoal> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((id, goal) -> builder.put(id, (Object)new SpeedrunGoal.Holder((ResourceLocation)id, (SpeedrunGoal)goal)));
        SpeedrunGoal.Holder.setHolders((Map<ResourceLocation, SpeedrunGoal.Holder>)builder.buildOrThrow());
        LOGGER.info("Updated SpeedrunGoal.Holder");
        ABSDebug.debug(1, l -> {
            l.info("Known keys: {}", map.keySet());
            Map loaded = FileToIdConverter.registry(GOAL_KEY).listMatchingResources(resourceManager);
            l.info("Load again ({}): {}", (Object)loaded.size(), (Object)loaded);
            String path = Registries.elementsDirPath(GOAL_KEY);
            String path2 = GOAL_KEY_ID.getPath();
            l.info("Path#1: {}, Path#2: {}, Equal: {}", new Object[]{path, path2, Objects.equals(path, path2)});
            loaded = FileToIdConverter.json((String)path).listMatchingResources(resourceManager);
            l.info("Load another time ({}): {}", (Object)loaded.size(), (Object)loaded);
        });
    }
}

