/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.view;

import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.TriState;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xland.mcmod.neospeedzero.util.ABSDebug;
import xland.mcmod.neospeedzero.view.AbstractSlottedScreen;
import xland.mcmod.neospeedzero.view.ChallengeSnapshot;

@OnlyIn(value=Dist.CLIENT)
public class ViewChallengeScreen
extends AbstractSlottedScreen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"textures/gui/view.png");
    private static final ResourceLocation SPRITE_YES = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"yes");
    private static final ResourceLocation SPRITE_NO = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"no");
    private final ChallengeSnapshot snapshot;
    int page;
    private final TriState[] cachedConditions;
    private PageButton prevButton;
    private PageButton nextButton;

    public ViewChallengeScreen(ChallengeSnapshot challengeSnapshot) {
        super(challengeSnapshot.title());
        this.snapshot = challengeSnapshot;
        this.cachedConditions = new TriState[63];
        Arrays.fill(this.cachedConditions, TriState.DEFAULT);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.addSlots();
        this.prevButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftPos + 7, this.topPos + 149, false, button -> this.previousPage(), false));
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftPos + 151, this.topPos + 149, true, button -> this.nextPage(), false));
        this.updateThisPage();
    }

    public void onDataUpdate(ChallengeSnapshot.Change change) {
        if (change.applyTo(this.snapshot)) {
            this.updateThisPage();
        }
    }

    private void addSlots() {
        for (int i = 0; i < 63; ++i) {
            this.slots.add(new AbstractSlottedScreen.FakeSlot(8 + 18 * (i % 9), 19 + 18 * (i / 9)));
        }
    }

    public int totalPageCount() {
        return this.snapshot.totalPageCount();
    }

    public void previousPage() {
        if (this.hasPreviousPage()) {
            --this.page;
            this.updateThisPage();
        }
    }

    public boolean hasPreviousPage() {
        int newPage = this.page - 1;
        return newPage >= 0 && newPage < this.totalPageCount();
    }

    public void nextPage() {
        if (this.hasNextPage()) {
            ++this.page;
            this.updateThisPage();
        }
    }

    public boolean hasNextPage() {
        int newPage = this.page + 1;
        return newPage >= 0 && newPage < this.totalPageCount();
    }

    protected void updateThisPage() {
        int indexFrom = Mth.clamp((int)(this.snapshot.challenges().size() - 1), (int)0, (int)(this.page * 63));
        int indexTo = Mth.clamp((int)this.snapshot.challenges().size(), (int)0, (int)((this.page + 1) * 63));
        this.slots.forEach(slot -> slot.setItemStack(ItemStack.EMPTY));
        Arrays.fill(this.cachedConditions, TriState.DEFAULT);
        int rawIndex = indexFrom;
        int slotIndex = 0;
        while (rawIndex < indexTo) {
            ((AbstractSlottedScreen.FakeSlot)this.slots.get(slotIndex)).setItemStack(this.snapshot.challenges().get(rawIndex));
            this.cachedConditions[slotIndex] = this.snapshot.successTimeMap()[rawIndex] >= 0L ? TriState.TRUE : TriState.FALSE;
            ++rawIndex;
            ++slotIndex;
        }
        this.updateButtonVisibility();
        ABSDebug.debug(2, l -> {
            l.info("Page: {}", (Object)this.page);
            l.info("Cached Conditions: {}", (Object)Arrays.toString(this.cachedConditions));
        });
    }

    private void updateButtonVisibility() {
        this.prevButton.visible = this.hasPreviousPage();
        this.nextButton.visible = this.hasNextPage();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderExtraBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 166);
        block4: for (int i = 0; i < 63; ++i) {
            AbstractSlottedScreen.FakeSlot fakeSlot = (AbstractSlottedScreen.FakeSlot)this.slots.get(i);
            switch (this.cachedConditions[i]) {
                case TRUE: {
                    this.blitSprite(guiGraphics, SPRITE_YES, fakeSlot.x(), fakeSlot.y());
                    continue block4;
                }
                case FALSE: {
                    this.blitSprite(guiGraphics, SPRITE_NO, fakeSlot.x(), fakeSlot.y());
                }
            }
        }
    }

    private void blitSprite(GuiGraphics guiGraphics, ResourceLocation sprite, int x, int y) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, 16, 16, 0, 0, this.leftPos + x, this.topPos + y, 16, 16);
    }
}

