/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.view;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.neospeedzero.NeoSpeedLifecycle;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.util.ABSDebug;
import xland.mcmod.neospeedzero.view.ChallengeSnapshot;
import xland.mcmod.neospeedzero.view.ViewChallengeScreen;

public interface ViewPackets {
    public static final ResourceLocation ID_SNAPSHOT = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"view_challenge");
    public static final CustomPacketPayload.Type<ChallengeSnapshot> TYPE_SNAPSHOT = new CustomPacketPayload.Type(ID_SNAPSHOT);
    public static final ResourceLocation ID_CHANGE = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"sync_challenge");
    public static final CustomPacketPayload.Type<ChallengeSnapshot.Change> TYPE_CHANGE = new CustomPacketPayload.Type(ID_CHANGE);
    public static final ResourceLocation ID_C2S_REQUEST = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"request_view_challenge");
    public static final CustomPacketPayload.Type<Request> TYPE_C2S_REQUEST = new CustomPacketPayload.Type(ID_C2S_REQUEST);

    public static void register() {
        ABSDebug.debug(4, l -> l.info("ViewPackets registering (1/2)"));
        if (Platform.getEnvironment() == Env.CLIENT) {
            class ClientBoundMethods {
                ClientBoundMethods() {
                }

                static void snapshot(ChallengeSnapshot snapshot) {
                    Minecraft.getInstance().setScreen((Screen)new ViewChallengeScreen(snapshot));
                }

                static void change(ChallengeSnapshot.Change change) {
                    Screen screen = Minecraft.getInstance().screen;
                    if (screen instanceof ViewChallengeScreen) {
                        ViewChallengeScreen viewChallengeScreen = (ViewChallengeScreen)screen;
                        viewChallengeScreen.onDataUpdate(change);
                    }
                }
            }
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), TYPE_SNAPSHOT, ChallengeSnapshot.STREAM_CODEC, (snapshot, context) -> context.queue(() -> ClientBoundMethods.snapshot(snapshot)));
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), TYPE_CHANGE, ChallengeSnapshot.Change.STREAM_CODEC, (change, context) -> ClientBoundMethods.change(change));
        } else {
            NetworkManager.registerS2CPayloadType(TYPE_SNAPSHOT, ChallengeSnapshot.STREAM_CODEC);
            NetworkManager.registerS2CPayloadType(TYPE_CHANGE, ChallengeSnapshot.Change.STREAM_CODEC);
        }
        ABSDebug.debug(4, l -> l.info("ViewPackets registered (2/2)"));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), TYPE_C2S_REQUEST, Request.STREAM_CODEC, (singleton, context) -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                SpeedrunRecord record = serverPlayer.ns0$currentRecord();
                if (record != null) {
                    NeoSpeedLifecycle.viewRecord(serverPlayer, record);
                } else {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{serverPlayer.getDisplayName()}));
                }
            }
        });
    }

    public static class Request
    implements CustomPacketPayload {
        public static final Request INSTANCE = new Request();
        public static final StreamCodec<RegistryFriendlyByteBuf, Request> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

        private Request() {
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE_C2S_REQUEST;
        }

        public String toString() {
            return "ViewPackets.Request";
        }
    }
}

