/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.api;

import net.minecraft.server.level.ServerPlayer;
import xland.mcmod.neospeedzero.api.SpeedrunStartupConfig;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.util.event.ActionResult;
import xland.mcmod.neospeedzero.util.event.Event;

public interface NeoSpeedLifecycleEvents {
    public static final Event<CompleteSingleChallenge, CompleteSingleChallenge> COMPLETE_SINGLE_CHALLENGE = Event.of(l -> (serverPlayer, record, index) -> {
        for (CompleteSingleChallenge e : l) {
            e.onComplete(serverPlayer, record, index);
        }
    });
    public static final Event<CompleteRecord, CompleteRecord> COMPLETE_RECORD = Event.of(l -> (serverPlayer, record) -> {
        for (CompleteRecord e : l) {
            e.onComplete(serverPlayer, record);
        }
    });
    public static final Event<StartRecord, StartRecord> START_RECORD = Event.of(l -> (player, startupConfig) -> {
        for (StartRecord e : l) {
            ActionResult result = e.onStart(player, startupConfig);
            if (!result.interrupts()) continue;
            return result;
        }
        return ActionResult.pass();
    });
    public static final Event<ForceStopRecord, ForceStopRecord> FORCE_STOP_RECORD = Event.of(l -> player -> {
        for (ForceStopRecord e : l) {
            ActionResult result = e.onStop(player);
            if (!result.interrupts()) continue;
            return result;
        }
        return ActionResult.pass();
    });

    @FunctionalInterface
    public static interface ForceStopRecord {
        public ActionResult onStop(ServerPlayer var1);
    }

    @FunctionalInterface
    public static interface StartRecord {
        public ActionResult onStart(ServerPlayer var1, SpeedrunStartupConfig var2);
    }

    @FunctionalInterface
    public static interface CompleteRecord {
        public void onComplete(ServerPlayer var1, SpeedrunRecord var2);
    }

    @FunctionalInterface
    public static interface CompleteSingleChallenge {
        public void onComplete(ServerPlayer var1, SpeedrunRecord var2, int var3);
    }
}

