/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.record;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.LongStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.NoticeDialog;
import net.minecraft.server.dialog.body.DialogBody;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import xland.mcmod.neospeedzero.NeoSpeedMessages;
import xland.mcmod.neospeedzero.difficulty.SpeedrunDifficulty;
import xland.mcmod.neospeedzero.record.SpeedrunChallenge;
import xland.mcmod.neospeedzero.resource.SpeedrunGoal;
import xland.mcmod.neospeedzero.util.DialogUtil;
import xland.mcmod.neospeedzero.util.TimeUtil;

public record SpeedrunRecord(SpeedrunGoal.Holder goal, UUID recordId, @Unmodifiable List<SpeedrunChallenge> challenges, long[] collectedTimes, long startTime, MutableLong finishTime, SpeedrunDifficulty difficulty) {
    public static final MapCodec<SpeedrunRecord> MAP_CODEC = SpeedrunRecord.createMapCodec().validate(SpeedrunRecord::validate);
    public static final Codec<SpeedrunRecord> CODEC = Codec.lazyInitialized(() -> MAP_CODEC.codec());

    public SpeedrunRecord(SpeedrunGoal.Holder goal, UUID recordId, List<SpeedrunChallenge> challenges, long startTime, SpeedrunDifficulty difficulty) {
        this(goal, recordId, challenges, SpeedrunRecord.initLA(challenges.size()), startTime, new MutableLong(-1L), difficulty);
    }

    public void markComplete(int index, long currentTime) {
        this.collectedTimes()[index] = currentTime;
    }

    public boolean shallComplete() {
        return Arrays.stream(this.collectedTimes()).allMatch(l -> l >= 0L);
    }

    public boolean hasCompleted() {
        return this.finishTime().longValue() >= 0L;
    }

    public int completedCount() {
        return (int)Arrays.stream(this.collectedTimes()).filter(l -> l >= 0L).count();
    }

    public int totalCount() {
        return this.challenges().size();
    }

    public Duration duration(long currentTime) {
        long ticks = currentTime - this.startTime();
        return Duration.ofSeconds(ticks / 20L, ticks % 20L * 50000000L);
    }

    @Contract(value="->new", pure=true)
    public Component snapshot() {
        return NeoSpeedMessages.snapshotFor(this, true);
    }

    private static long[] initLA(int size) {
        long[] l = new long[size];
        Arrays.fill(l, -1L);
        return l;
    }

    private static MapCodec<SpeedrunRecord> createMapCodec() {
        Codec mutableLongCodec = Codec.LONG.xmap(MutableLong::new, MutableLong::toLong);
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpeedrunGoal.HOLDER_CODEC.fieldOf("goal").forGetter(SpeedrunRecord::goal), (App)UUIDUtil.STRING_CODEC.fieldOf("recordId").forGetter(SpeedrunRecord::recordId), (App)SpeedrunChallenge.CODEC.listOf(1, Integer.MAX_VALUE).fieldOf("challenges").forGetter(SpeedrunRecord::challenges), (App)Codec.LONG_STREAM.xmap(LongStream::toArray, LongStream::of).fieldOf("collectedTimes").forGetter(SpeedrunRecord::collectedTimes), (App)Codec.LONG.fieldOf("startTime").forGetter(SpeedrunRecord::startTime), (App)mutableLongCodec.fieldOf("finishTime").forGetter(SpeedrunRecord::finishTime), (App)SpeedrunDifficulty.CODEC.fieldOf("difficulty").forGetter(SpeedrunRecord::difficulty)).apply((Applicative)instance, SpeedrunRecord::new));
    }

    public DataResult<SpeedrunRecord> validate() {
        if (this.challenges().size() != this.collectedTimes().length) {
            return DataResult.error(() -> "Different sizes between challenges (" + this.challenges().size() + ") and collectedTimes (" + this.collectedTimes().length + ")");
        }
        return DataResult.success((Object)this);
    }

    public Dialog asDialog() {
        ArrayList<DialogBody> dialogBodies = new ArrayList<DialogBody>(this.challenges().size());
        int index = 0;
        long[] timeMap = this.collectedTimes();
        for (SpeedrunChallenge challenge : this.challenges()) {
            long time;
            ItemStack icon = challenge.icon();
            ChatFormatting color = (time = timeMap[index++]) >= 0L ? ChatFormatting.GREEN : ChatFormatting.RED;
            dialogBodies.add((DialogBody)DialogUtil.itemBody(icon, (Component)Component.empty().append(icon.getHoverName()).withStyle(style -> {
                style = style.withColor(color);
                if (time >= 0L) {
                    style = style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"message.neospeedzero.challenge.finished_in", (Object[])new Object[]{TimeUtil.duration(this, time)})));
                }
                return style;
            })));
        }
        return new NoticeDialog(DialogUtil.commonDialogData(NeoSpeedMessages.snapshotFor(this, false), false, dialogBodies), NoticeDialog.DEFAULT_ACTION);
    }
}

