/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.resource;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.BundlePredicate;
import net.minecraft.core.component.predicates.DamagePredicate;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.JukeboxPlayablePredicate;
import net.minecraft.core.component.predicates.PotionsPredicate;
import net.minecraft.core.component.predicates.TrimPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.neospeedzero.mixin.EnchantmentsPredicateAccessor;

final class ExtraRequirements {
    ExtraRequirements() {
    }

    /*
     * Loose catch block
     */
    static void fillExtraRequirements(ItemStack stack, @Nullable Either<TagKey<Item>, HolderSet<Item>> ofAny, @Nullable ItemPredicate predicate) {
        block17: {
            ArrayList<MutableComponent> appendedLores = new ArrayList<MutableComponent>();
            if (predicate != null) {
                Optional<Object> optional;
                BundlePredicate bundlePredicate;
                Object v;
                Map partial;
                block16: {
                    DataComponentPatch componentChanges;
                    block15: {
                        MinMaxBounds.Ints count = predicate.count();
                        if (!count.isAny()) {
                            appendedLores.add(Component.translatable((String)"item_predicate.neospeedzero.extra_req.count", (Object[])new Object[]{ExtraRequirements.formatIntRange(count)}));
                        }
                        componentChanges = predicate.components().exact().asPatch();
                        partial = predicate.components().partial();
                        stack.applyComponents(componentChanges);
                        stack.remove(DataComponents.DAMAGE);
                        ExtraRequirements.componentFromChanges(componentChanges, DataComponents.DAMAGE).ifPresentOrElse(damage -> appendedLores.add(Component.translatable((String)"item_predicate.neospeedzero.extra_req.damage", (Object[])new Object[]{ExtraRequirements.formatNumber(damage, damage)})), () -> {
                            Object patt1$temp = partial.get(DataComponentPredicates.DAMAGE);
                            if (patt1$temp instanceof DamagePredicate) {
                                MinMaxBounds.Ints patt3$temp;
                                MinMaxBounds.Ints durability;
                                DamagePredicate $b$0 = (DamagePredicate)patt1$temp;
                                try {
                                    MinMaxBounds.Ints patt2$temp;
                                    durability = patt2$temp = $b$0.durability();
                                }
                                catch (Throwable throwable) {
                                    throw new MatchException(throwable.toString(), throwable);
                                }
                                MinMaxBounds.Ints damage = patt3$temp = $b$0.damage();
                                appendedLores.add(Component.translatable((String)"item_predicate.neospeedzero.extra_req.durability", (Object[])new Object[]{ExtraRequirements.formatIntRange(durability)}));
                                appendedLores.add(Component.translatable((String)"item_predicate.neospeedzero.extra_req.damage", (Object[])new Object[]{ExtraRequirements.formatIntRange(damage)}));
                            }
                        });
                        ExtraRequirements.readEnchantments((DataComponentPredicate)partial.get(DataComponentPredicates.STORED_ENCHANTMENTS), appendedLores::add);
                        ExtraRequirements.readEnchantments((DataComponentPredicate)partial.get(DataComponentPredicates.ENCHANTMENTS), appendedLores::add);
                        v = partial.get(DataComponentPredicates.BUNDLE_CONTENTS);
                        if (v instanceof BundlePredicate) {
                            bundlePredicate = (BundlePredicate)v;
                            Optional items = optional = bundlePredicate.items();
                            if (!items.isPresent()) break block15;
                            appendedLores.add(Component.translatable((String)"item_predicate.neospeedzero.extra_req.bundle"));
                        }
                    }
                    if (partial.containsKey(DataComponentPredicates.CUSTOM_DATA) || ExtraRequirements.componentFromChanges(componentChanges, DataComponents.CUSTOM_DATA).isPresent()) {
                        appendedLores.add(Component.translatable((String)"item_predicate.neospeedzero.extra_req.custom_data"));
                    }
                    if ((v = partial.get(DataComponentPredicates.JUKEBOX_PLAYABLE)) instanceof JukeboxPlayablePredicate) {
                        bundlePredicate = (JukeboxPlayablePredicate)v;
                        Optional song = optional = bundlePredicate.song();
                        if (!song.isPresent()) break block16;
                        ExtraRequirements.appendHomogenousSet(Component.translatable((String)"item_predicate.neospeedzero.extra_req.song"), (HolderSet)song.get(), appendedLores::add);
                    }
                }
                if ((v = partial.get(DataComponentPredicates.POTIONS)) instanceof PotionsPredicate) {
                    bundlePredicate = (PotionsPredicate)v;
                    Optional<Object> potions = optional = bundlePredicate.potions();
                    ExtraRequirements.appendHomogenousSet(Component.translatable((String)"item_predicate.neospeedzero.extra_req.potion"), potions, appendedLores::add);
                }
                if ((optional = partial.get(DataComponentPredicates.ARMOR_TRIM)) instanceof TrimPredicate) {
                    Optional optional2;
                    bundlePredicate = (TrimPredicate)optional;
                    Optional material = optional2 = bundlePredicate.material();
                    Optional pattern = optional2 = bundlePredicate.pattern();
                    material.ifPresent(holders -> ExtraRequirements.appendHomogenousSet(Component.translatable((String)"item_predicate.neospeedzero.extra_req.trim.material"), holders, appendedLores::add));
                    pattern.ifPresent(holders -> ExtraRequirements.appendHomogenousSet(Component.translatable((String)"item_predicate.neospeedzero.extra_req.trim.patterns"), holders, appendedLores::add));
                }
            }
            if (ofAny != null) {
                ExtraRequirements.appendHomogenousSet(Component.translatable((String)"item_predicate.neospeedzero.extra_req.items"), ofAny, appendedLores::add);
            }
            if (!appendedLores.isEmpty()) {
                List lines = Optional.ofNullable((ItemLore)stack.get(DataComponents.LORE)).map(ItemLore::lines).orElse(Collections.emptyList());
                lines = new ArrayList(lines);
                lines.addAll(appendedLores);
                stack.set(DataComponents.LORE, (Object)new ItemLore(lines));
            }
            break block17;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    private static void readEnchantments(@Nullable DataComponentPredicate componentPredicate, Consumer<Component> loreAdder) {
        if (componentPredicate instanceof EnchantmentsPredicateAccessor) {
            EnchantmentsPredicateAccessor enchantmentsPredicate = (EnchantmentsPredicateAccessor)componentPredicate;
            enchantmentsPredicate.ns0$getEnchantments().forEach(enchantmentPredicate -> {
                Optional enchantments = enchantmentPredicate.enchantments();
                MinMaxBounds.Ints levels = enchantmentPredicate.level();
                if (enchantments.isEmpty()) {
                    loreAdder.accept((Component)Component.translatable((String)"item_predicate.neospeedzero.extra_req.enchantments.any", (Object[])new Object[]{ExtraRequirements.formatIntRange(levels)}));
                } else {
                    int size = ((HolderSet)enchantments.get()).size();
                    if (size == 0) {
                        return;
                    }
                    loreAdder.accept((Component)Component.empty().append(((Enchantment)((HolderSet)enchantments.get()).get(0).value()).description()).append(size == 1 ? " " : "... ").append(ExtraRequirements.formatIntRange(levels)));
                }
            });
        }
    }

    private static Component formatIntRange(MinMaxBounds.Ints intRange) {
        return ExtraRequirements.formatNumber(intRange.min().orElse(null), intRange.max().orElse(null));
    }

    @Contract(value="null, null -> fail")
    private static Component formatNumber(@Nullable Integer min, @Nullable Integer max) {
        Preconditions.checkArgument((min != null || max != null ? 1 : 0) != 0);
        if (min == null) {
            return Component.translatable((String)"item_predicate.neospeedzero.extra_req.count.max", (Object[])new Object[]{max});
        }
        if (max == null) {
            return Component.translatable((String)"item_predicate.neospeedzero.extra_req.count.min", (Object[])new Object[]{min});
        }
        if (min.equals(max)) {
            return Component.translatable((String)"item_predicate.neospeedzero.extra_req.count.exact", (Object[])new Object[]{min});
        }
        return Component.translatable((String)"item_predicate.neospeedzero.extra_req.count.between", (Object[])new Object[]{min, max});
    }

    private static <T> Optional<? extends T> componentFromChanges(DataComponentPatch changes, DataComponentType<? extends T> componentType) {
        Optional t = changes.get(componentType);
        if (t == null) {
            return Optional.empty();
        }
        return t;
    }

    private static <T> Stream<String> formatHomogenousSet(Either<TagKey<T>, HolderSet<T>> unwrapped) {
        return (Stream)unwrapped.map(tagKey -> Stream.of("#" + String.valueOf(tagKey.location())), holders -> holders.stream().map(Holder::getRegisteredName));
    }

    private static <T> void appendHomogenousSet(MutableComponent prefix, Either<TagKey<T>, HolderSet<T>> unwrapped, Consumer<Component> loreAdder) {
        String text = ExtraRequirements.formatHomogenousSet(unwrapped).map(s -> "\n - " + s).collect(Collectors.joining());
        loreAdder.accept((Component)prefix.append(text));
    }

    private static <T> void appendHomogenousSet(MutableComponent prefix, HolderSet<T> wrapped, Consumer<Component> loreAdder) {
        ExtraRequirements.appendHomogenousSet(prefix, wrapped.unwrap().mapRight(HolderSet::direct), loreAdder);
    }
}

