/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.resource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xland.mcmod.neospeedzero.record.SpeedrunChallenge;
import xland.mcmod.neospeedzero.resource.ItemGoalPredicate;
import xland.mcmod.neospeedzero.resource.StatedIcon;

public sealed interface GoalPredicate {
    public static final Codec<GoalPredicate> CODEC = Codec.lazyInitialized(() -> Codec.either(OfAdvancement.CODEC, OfItemPredicate.CODEC).xmap(either -> (GoalPredicate)either.map(Function.identity(), Function.identity()), p -> {
        GoalPredicate goalPredicate = p;
        Objects.requireNonNull(goalPredicate);
        GoalPredicate selector0$temp = goalPredicate;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OfAdvancement.class, OfItemPredicate.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                OfAdvancement ofAdvancement = (OfAdvancement)selector0$temp;
                yield Either.left((Object)ofAdvancement);
            }
            case 1 -> {
                OfItemPredicate ofItemPredicate = (OfItemPredicate)selector0$temp;
                yield Either.right((Object)ofItemPredicate);
            }
        };
    }));

    public Optional<StatedIcon> icon();

    public Stream<SpeedrunChallenge> stream();

    public record OfAdvancement(ResourceKey<Advancement> advancementKey, Optional<StatedIcon> icon) implements GoalPredicate
    {
        public static final Codec<OfAdvancement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ADVANCEMENT).fieldOf("advancement").forGetter(OfAdvancement::advancementKey), (App)StatedIcon.CODEC.optionalFieldOf("icon").forGetter(OfAdvancement::icon)).apply((Applicative)instance, OfAdvancement::new));

        public static ItemStack generatedIcon() {
            return Items.GRASS_BLOCK.getDefaultInstance();
        }

        @Override
        public Stream<SpeedrunChallenge> stream() {
            return Stream.of(SpeedrunChallenge.of((Either<ItemPredicate, ResourceKey<Advancement>>)Either.right(this.advancementKey), OfAdvancement.generatedIcon(), this.icon));
        }
    }

    public static abstract sealed class OfItemPredicate
    implements GoalPredicate
    permits ItemGoalPredicate, Basic {
        @Nullable
        private final StatedIcon statedIcon;
        @Nullable
        protected final ItemPredicate subPredicate;
        public static final Codec<OfItemPredicate> CODEC = Codec.lazyInitialized(() -> Codec.either(ItemGoalPredicate.CODEC, Basic.CODEC).xmap(either -> (OfItemPredicate)either.map(Function.identity(), Function.identity()), p -> {
            OfItemPredicate ofItemPredicate = p;
            Objects.requireNonNull(ofItemPredicate);
            OfItemPredicate selector0$temp = ofItemPredicate;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemGoalPredicate.class, Basic.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ItemGoalPredicate itemGoalPredicate = (ItemGoalPredicate)selector0$temp;
                    yield Either.left((Object)itemGoalPredicate);
                }
                case 1 -> {
                    Basic basic = (Basic)selector0$temp;
                    yield Either.right((Object)basic);
                }
            };
        }));

        protected OfItemPredicate(Optional<StatedIcon> statedIcon, Optional<ItemPredicate> subPredicate) {
            this.statedIcon = statedIcon.orElse(null);
            this.subPredicate = subPredicate.orElse(null);
        }

        @Override
        public Optional<StatedIcon> icon() {
            return Optional.ofNullable(this.statedIcon);
        }

        public static ItemStack theAnyApple() {
            ItemStack stack = new ItemStack((ItemLike)Items.APPLE);
            stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item_predicate.neospeedzero.extra_req.items.any"));
            return stack;
        }

        @Override
        public Stream<SpeedrunChallenge> stream() {
            ItemPredicate itemPredicate = this.subPredicate;
            if (itemPredicate == null) {
                itemPredicate = ItemPredicate.Builder.item().build();
            }
            return Stream.of(SpeedrunChallenge.of((Either<ItemPredicate, ResourceKey<Advancement>>)Either.left((Object)itemPredicate), OfItemPredicate.theAnyApple(), this.icon()));
        }

        static final class Basic
        extends OfItemPredicate {
            public static final Codec<Basic> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StatedIcon.CODEC.optionalFieldOf("icon").forGetter(OfItemPredicate::icon), (App)ItemPredicate.CODEC.optionalFieldOf("item_predicate").forGetter(p -> Optional.ofNullable(p.subPredicate))).apply((Applicative)instance, Basic::new));

            Basic(Optional<StatedIcon> statedIcon, Optional<ItemPredicate> subPredicate) {
                super(statedIcon, subPredicate);
            }
        }
    }
}

