/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.resource.loader;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import xland.mcmod.neospeedzero.resource.SpeedrunGoal;
import xland.mcmod.neospeedzero.util.event.PlatformEvents;

public class SpeedrunGoalManager
extends SimpleJsonResourceReloadListener<SpeedrunGoal> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation GOAL_KEY_ID = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"goals");
    public static final ResourceKey<Registry<SpeedrunGoal>> GOAL_KEY = ResourceKey.createRegistryKey((ResourceLocation)GOAL_KEY_ID);

    private SpeedrunGoalManager(HolderLookup.Provider provider) {
        super(provider, SpeedrunGoal.CODEC, GOAL_KEY);
    }

    public static void registerEvents() {
        PlatformEvents.getInstance().registerResourceReloadListener(GOAL_KEY_ID, SpeedrunGoalManager::new);
    }

    protected void apply(Map<ResourceLocation, SpeedrunGoal> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((id, goal) -> builder.put(id, (Object)new SpeedrunGoal.Holder((ResourceLocation)id, (SpeedrunGoal)goal)));
        SpeedrunGoal.Holder.setHolders((Map<ResourceLocation, SpeedrunGoal.Holder>)builder.buildOrThrow());
        LOGGER.info("Updated SpeedrunGoal.Holder");
    }
}

